<?php
include ("jpgraph.php");
include ("jpgraph_line.php");



/************************************************************************
*	Graphing code for COREX Database						*
*	for use with JPGraph Copyright (C) 2001,2002 Johan Persson		*	
* 												*
*	Written by	David Tulumello July 2003					*
*	Updated by  Jacob Stewart-Ornstein June 2005				*
*	filename:	GraphActual.php							*
*	last updated:	May 8/2006							*
************************************************************************/


/************************************************************************
*		Obtains the defined variables from query string of url	*
*		Any undefined variables are set to default values		*
*************************************************************************/

$submit = $_POST['xmin'];

if (!(isset($submit))) {
$form = $_GET['form'];
$data = $_GET['data'];
$molecule = $_GET['molecule'];
$xmin = $_GET['xmin'];
$xmax = $_GET['xmax'];
}
else{
$form = $_POST['form'];
$data = $_POST['data'];
$molecule = $_POST['molecule'];
$xmin = $_POST['xmin'];
$xmax = $_POST['xmax'];
}
		//which form the data is in see below for details of each form
if (!$form)
{
$form = 1;}

if (!$data)
{
$data = a;}	

/********************	Data Forms	***********************************

Form		X1			Y1		X2		Y2

1		Energy		raw data	--		Oscillator Strength per atom
		(eV)			(counts)	--		(10-2 eV-1)

2		Energy		Mass Abs.	Energy	Oscillator Strength per atom
		(eV)			Coeff.	(eV)		(10-2 eV-1)

3		Energy		raw data	Energy	Oscillator Strength per atom
		(eV)			(counts)	(eV)		(10-2 eV-1)

4		Energy		raw data	---		---
		(eV)			(counts)

5		Energy		raw data	 - N2		Oscillator Strength per atom
		(eV)			(counts)	(counts)	(10-2 eV-1)
**********************************************************************/


$var1 = $_GET['var1'];
if (!$var1)
{
$var1 = 5;}				//line containing compound name

$var2 = $_GET['var2'];
if (!$var2)
{			
$var2 = 6;}				//line containing the edge

$var3 = $_GET['var3'];
if (!$var3)
{
$var3 = 20;}			//line which data beings

$var4a = $_GET['var4a'];	//number of digits in each data point(includes decimals, "E" and space for '-' sign)
if (!$var4a)					//first data point
{
$var4a = 13;}

$var4b = $_GET['var4b'];
if (!$var4b)
{
$var4b = 13;}					//second data point

$var4c = $_GET['var4c'];
if (!$var4c)
{
$var4c = 13;}					//third data point

$var4d = $_GET['var4d'];
if (!$var4d)					//fourth data point
{
$var4d = 13;}

$var4 = $_GET['var4'];		//sets all variables to same number is a universal variable is defined
if ($var4)
{
$var4a = $var4;
$var4b = $var4;
$var4c = $var4;
$var4d = $var4;
}			

$var5a = $_GET['var5a'];		//number of characters between columns of data (includes tabs and spaces)
if (!$var5a)					//first space
{
$var5a = 2;}

$var5b = $_GET['var5b'];
if (!$var5b)
{
$var5b = 2;}					//second space		

$var5c = $_GET['var5c'];
if (!$var5c)
{
$var5c = 2;}					//third space

$var5 = $_GET['var5'];		//sets all variables to same number is a universal variable is defined
if ($var5)
{
$var5a = $var5;
$var5b = $var5;
$var5c = $var5;
$var5d = $var5;
}


$var6 = $_GET['var6'];
if (!$var6)
{
$var6 = ' ';}			//character which begins each row of data

$var7 = $_GET['var7'];
if (!$var7)
{
$var7 = 3;}				//number of data columns

$filepath = $molecule;
if (!$filepath)
{
$filepath = 'data\Ah-0cckk.os';}



/**********************************************************************
*************	Reading from a file	*****************************
**********************************************************************/

$file=fopen($filepath,'r');

if (!$file)
{
echo '<b>Error: File not Found <br> Contact Administrator';
exit;
}


//reads lines 1-4

$line_num = 1;

while ($line_num < $var1)
	{
fgets($file,4096);
$line_num = $line_num + 1;
	}


fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);

$name = fgets($file,4096);

$name = rtrim($name);	//removes the line return from the end of the string

$line_num = $line_num + 1; 



while ($line_num < $var2)
	{
fgets($file,4096);
$line_num = $line_num + 1; 
	}

fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);
fgetc($file);

$edge = fgets($file,4096);

$edge = rtrim($edge);			//removes the line return from the end of the string
$line_num = $line_num + 1; 


while ($line_num < $var3)
	{
fgets($file,4096);
$line_num = $line_num + 1;
	}

fgetc($file);

$i = 0;
$end_check = 1;

do 
	{

	$DataLine = trim(fgets($file,4096), ",");
	$SplitData = preg_split("/\b[\s,]+/", ($DataLine));

	$xdata1[$i] = (float)($SplitData[0]);

	//Y data 1

	$ydata1[$i] = (float)($SplitData[1]);

	//X/Y data 2	
	if (($form != 4)&&($end_check != 2)&&(count($SplitData)>2))
	{
		$ydata2[$i] = (float)($SplitData[2]);
	}

	// YData 2
	if ((($form == 2 )||( $form == 3))&&($end_check != 2)&&(count($SplitData)>3))
	{
		$xdata2[$i] = $ydata2[$i];
		$ydata2[$i] = (float)($SplitData[3]);	
	}
	else
	{
		if ($end_check != 2)
		{
			$xdata2[$i] = $xdata1[$i];
		}
	}	

	if (($form == 5)&&($end_check != 2)&&(count($SplitData)>3))
		{
			$ydata3[$i] = (float)($SplitData[3]);
			$xdata2[$i] = $xdata1[$i];
			$xdata3[$i] = $xdata1[$i];	
		}


	fgets($file,4096);
	$check = fgetc($file);
	$i = $i +1;

	}while ($check == $var6);		//stops getting data files once end of file is reached

fclose($file);


/******************************************************************************
*************	Graphing Procedure ******************************************
******************************************************************************/

//Setting titles for axis

if(($form == 1)||($form == 3))
	{
	$x1_name = 'Energy (eV)';
	$y1_name = 'Counts';
	$x2_name = 'Energy (eV)';
	$y2_name = 'Oscil. Strength per atom (10-2 eV-1)';
	}

if($form == 2)
	{
	$x1_name = 'Energy (eV)';
	$y1_name = 'Mass Abs. Coeff.';
	$x2_name = 'Energy (eV)';
	$y2_name = 'Oscil. Strength per atom (10-2 eV-1)';
	}

if($form == 4)
	{
	$x1_name = 'Energy (eV)';
	$y1_name = 'Counts';
	}

if($form == 5)
	{
	$x1_name = 'Energy (eV)';
	$y1_name = 'Counts';
	$x2_name = 'Energy (eV)';
	$y2_name = 'Counts';
	$x3_name = 'Energy (eV)';
	$y3_name = 'Oscil. Strength per atom (10-2 eV-1)';
	}

//Sets up axis and titles to be used if rough data or oscillator strength is selected


if ($data == b)
	{
	$xaxis_name = $x2_name;
	$xdata = $xdata2;
	$yaxis_name = $y2_name;
	$ydata = $ydata2;
		$ci = 0;
		$val = 0;
		do
		{
		$ci = $ci + 1;
		$val = $xdata[count($xdata)-1 - $ci];
		}while ($val == 0);

    		$xdata = array_slice($xdata, 0, count($xdata)-$ci);
    		$ydata = array_slice($ydata, 0, count($ydata)-$ci);
	}

else if ($data == c)
	{
	$xaxis_name = $x3_name;
	$xdata = $xdata3;
	$yaxis_name = $y3_name;
	$ydata = $ydata3;
	}

else
	{
	$xaxis_name = $x1_name;
	$xdata = $xdata1;
	$yaxis_name = $y1_name;
	$ydata = $ydata1;
	$ci = 0;
	$val = 0;
	do
	{
	$ci = $ci + 1;
	$val = $xdata[count($xdata)-1 - $ci];
	}while ($val == 0);

    	$xdata = array_slice($xdata, 0, count($xdata)-$ci);
    	$ydata = array_slice($ydata, 0, count($ydata)-$ci);
	}
	
$ci = 0;
if (ceil($ydata[count($xdata)-1]) == 0)
	{
		do
		{
		$ci = $ci + 1;
		}while (ceil($ydata[count($ydata)-1 - $ci]) == 0);

		$xdata = array_slice($xdata, 0, count($xdata)-$ci);
    		$ydata = array_slice($ydata, 0, count($ydata)-$ci);
	}


//Rough Data
// Create the graph. These two calls are always required


for ($j=0; ($j<(count($xdata)-2));$j=$j+1)
{
 if ($xdata[$j]<$xmin and $xdata[$j+1]>$xmin)
  {
   $q=$j+1;
  }
 if ($xdata[$j]<$xmax and $xdata[$j+1]>$xmax)
  {
   $r=$j+1;
  }
}
if (!isset($q))
 {
  $q=0;
 }
if (!isset($r))
 {
  $r=0;
 }
if ($q==0 and $r<>0)
   {
    $xdata = array_slice($xdata, 0, $r-1);
    $ydata = array_slice($ydata, 0, $r-1);
   }
  elseif ($q<>0 and $r==0)
   {
    $xdata = array_slice($xdata, $q, count($xdata)-$q);
    $ydata = array_slice($ydata, $q, count($ydata)-$q);    
   }
  elseif ($q<>0 and $r<>0)
   {
    $xdata = array_slice($xdata, $q, $r-$q);
    $ydata = array_slice($ydata, $q, $r-$q);
   }



$graph = new Graph(600,400,"auto");	
$graph->SetScale("linlin", $aYMin, $aYMax, $xmin, $xmax);


// Create the linear plot
$lineplot=new LinePlot($ydata,$xdata);
$lineplot->SetColor("blue");
$lineplot ->SetWeight(2); 

// Add the plot to the graph
$graph->Add($lineplot);



//Set Titles and Axis name

//Set Title name and attributes
$graph->title->Set($name);
$graph->title->SetFont(FF_COMIC,FS_NORMAL,22);
$graph->title->SetColor('white');
$graph->subtitle->Set($edge);
$graph->subtitle->SetColor('white');


$graph->xaxis->title->Set("$xaxis_name");
$graph->xaxis->title->SetColor('white');
$graph->xaxis->SetTitleMargin(15);
$graph->xaxis->title->SetFont(FF_COMIC,FS_NORMAL,16);
$graph->xaxis->SetPos('min'); 


$graph->yaxis->title->Set("$yaxis_name");
$graph->yaxis->SetTitleMargin(50);
$graph->yaxis->title->SetColor('white');
$graph->yaxis->title->SetFont(FF_COMIC,FS_NORMAL,16);

$graph->xaxis->SetColor("blue","white");
$graph->yaxis->SetColor("blue","white");



$graph->SetMarginColor('dodgerblue4');

//Add shadow effect
$graph->SetShadow();


// Display the graph
$graph->Stroke();


?>

