/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class outputTrap
extends PrintStream {
    static OutputStream logfile = null;
    static PrintStream saveStdout;
    static PrintStream saveStderr;
    static ByteArrayOutputStream buffer;
    static String m_eol;
    static int MODE_SENDALLTHREADS;
    static int MODE_SENDMAINTHREAD;
    static int MODE_BUFFERNONMAINTHREADS;
    static int m_iMode;

    public outputTrap(PrintStream printStream) {
        super(printStream);
        this.init(MODE_SENDMAINTHREAD);
    }

    outputTrap(PrintStream printStream, int n) {
        super(printStream);
        this.init(n);
    }

    private void init(int n) {
        m_iMode = n;
        if (m_iMode == MODE_BUFFERNONMAINTHREADS) {
            buffer = new ByteArrayOutputStream();
            m_eol = System.getProperty("line.separator");
        }
    }

    public static synchronized native void nativePrint(String var0);

    public static synchronized void flushBuffer() {
        if (m_iMode == MODE_BUFFERNONMAINTHREADS) {
            if (!Thread.currentThread().getName().equals("main")) {
                return;
            }
            if (buffer != null) {
                try {
                    if (buffer.size() > 0) {
                        String string = buffer.toString();
                        int n = 0;
                        while ((n = string.indexOf(m_eol)) > 0) {
                            String string2 = string.substring(0, n);
                            outputTrap.nativePrint(string2);
                            string = string.substring(n + m_eol.length());
                        }
                    }
                    buffer.reset();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static void start(String string) throws IOException {
        saveStdout = System.out;
        saveStderr = System.err;
        if (string != null) {
            logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
        }
        System.setOut(new outputTrap(System.out));
        System.setErr(new outputTrap(System.err));
    }

    public static void stop() {
        System.setOut(saveStdout);
        System.setErr(saveStderr);
        try {
            if (logfile != null) {
                logfile.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void write(int n) {
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        try {
            if (logfile != null) {
                logfile.write(byArray, n, n2);
            }
            if (m_iMode == MODE_SENDALLTHREADS) {
                outputTrap.nativePrint(new String(byArray, n, n2));
            } else if (m_iMode == MODE_SENDMAINTHREAD) {
                if (Thread.currentThread().getName().equals("main")) {
                    outputTrap.nativePrint(new String(byArray, n, n2));
                }
            } else if (Thread.currentThread().getName().equals("main")) {
                outputTrap.flushBuffer();
                outputTrap.nativePrint(new String(byArray, n, n2));
            } else {
                buffer.write(byArray, n, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.setError();
        }
    }

    static {
        buffer = null;
        MODE_SENDALLTHREADS = 0;
        MODE_SENDMAINTHREAD = 1;
        MODE_BUFFERNONMAINTHREADS = 2;
    }
}

