/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.EBUtilities;
import java.io.File;
import java.net.URL;

public class JIDLPlatform {
    private static final String SEP = File.separator;
    private static final char SEP_CHAR = File.separatorChar;
    private static final String JAVA_DIR_KEYWORD = "JavaDir";
    private static final String JAVAPAL_DIR_KEYWORD = "JavaPALDir";
    private static final String BML_DIR_KEYWORD = "BMLDir";
    private static final String EBUTILS_DIR_KEYWORD = "EBUtilsDir";
    private static final String DEBUG_KEYWORD = "IDL_LOAD_DEBUG";
    protected static String g_osArch;
    protected static String g_osName;
    private static boolean g_bShowLoadDebug;
    private static String g_javaDir;
    private static String g_ebutilsDir;
    private static String g_bmlDir;
    private static String g_javapalDir;
    static /* synthetic */ Class class$com$idl$javaidl$JIDLPlatform;

    private static void calcLibraryLocations() {
        if (JIDLPlatform.isWindows()) {
            JIDLPlatform.calcEBUtilsLocation();
            EBUtilities.initialize(g_ebutilsDir);
            g_javapalDir = EBUtilities.checkForLibraryLocation(JAVAPAL_DIR_KEYWORD, g_bShowLoadDebug);
            g_bmlDir = EBUtilities.checkForLibraryLocation(BML_DIR_KEYWORD, g_bShowLoadDebug);
        }
    }

    protected static String getJavaPALLibraryLocation() {
        return g_javapalDir;
    }

    protected static String getBMLLibraryLocation() {
        return g_bmlDir;
    }

    protected static String getJavaLibraryLocation() {
        return g_javaDir;
    }

    private static void calcEBUtilsLocation() {
        boolean bl = true;
        if (JIDLPlatform.isWindows()) {
            String string = System.getProperty(EBUTILS_DIR_KEYWORD);
            if (string == null) {
                bl = false;
                String string2 = JIDLPlatform.findLoadedJarPath("javaidlb.jar");
                String string3 = "bin.x86";
                if (g_osArch.equals("amd64")) {
                    string3 = "bin.x86_64";
                }
                string = string2 + ".." + SEP + ".." + SEP + ".." + SEP + ".." + SEP + "bin" + SEP + string3;
            }
            g_ebutilsDir = string;
            if (g_bShowLoadDebug) {
                System.out.println("EBUtils location : " + g_ebutilsDir + (bl ? " (set via Java command line)" : " (set relative to javaidlb.jar)"));
            }
        }
    }

    private static void calcJavaLibLocation() {
        boolean bl = true;
        g_javaDir = System.getProperty(JAVA_DIR_KEYWORD);
        if (g_javaDir == null) {
            bl = false;
            String string = System.getProperty("java.home");
            g_javaDir = g_osName.startsWith("Mac") && g_osArch.equals("i386") ? string + SEP + ".." + SEP + "Libraries" : (JIDLPlatform.isWindows() ? string + SEP + "bin" : string + SEP + "lib" + SEP + g_osArch);
        }
        if (g_bShowLoadDebug) {
            System.out.println("Java location : " + g_javaDir + (bl ? " (set via Java command line)" : " (set relative to java.home property)"));
        }
    }

    public static String findLoadedJarPath(String string) {
        String string2 = null;
        ClassLoader classLoader = (class$com$idl$javaidl$JIDLPlatform == null ? (class$com$idl$javaidl$JIDLPlatform = JIDLPlatform.class$("com.idl.javaidl.JIDLPlatform")) : class$com$idl$javaidl$JIDLPlatform).getClassLoader();
        URL uRL = classLoader.getResource("com/idl/javaidl/JIDLPlatform.class");
        string2 = uRL.getFile();
        int n = string2.indexOf(string);
        if (n >= 0) {
            if ((string2 = string2.substring(0, n)).startsWith("file:")) {
                string2 = string2.substring(5);
            }
            if ((string2 = string2.replace('/', SEP_CHAR)).startsWith(SEP)) {
                string2 = string2.substring(1);
            }
            string2 = string2.replaceAll("%20", " ");
        }
        return string2;
    }

    public static boolean platformSupportsGraphics() {
        return !g_osName.startsWith("Mac");
    }

    protected static boolean isWindows() {
        return g_osName.startsWith("Windows");
    }

    private static int loadLibraryPerDefaultPath(String string) {
        int n = 0;
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError.getMessage().toLowerCase().indexOf("already loaded") >= 0) {
                n = 0;
            } else {
                if (g_bShowLoadDebug) {
                    System.err.println("*** " + unsatisfiedLinkError);
                }
                n = -1;
            }
        }
        catch (Throwable throwable) {
            if (g_bShowLoadDebug) {
                System.err.println("*** " + throwable);
            }
            n = -1;
        }
        return n;
    }

    private static int loadExplicitLibrary(String string, String string2) {
        int n = 0;
        try {
            String string3 = string + SEP + System.mapLibraryName(string2);
            System.load(string3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError.getMessage().toLowerCase().indexOf("already loaded") >= 0) {
                n = 0;
            } else {
                if (g_bShowLoadDebug) {
                    System.err.println("*** " + unsatisfiedLinkError);
                }
                n = -1;
            }
        }
        catch (Throwable throwable) {
            if (g_bShowLoadDebug) {
                System.err.println("*** " + throwable);
            }
            n = -1;
        }
        return n;
    }

    protected static int loadNeededLibrary(String string, String string2) {
        int n = 0;
        n = string == null ? JIDLPlatform.loadLibraryPerDefaultPath(string2) : JIDLPlatform.loadExplicitLibrary(string, string2);
        if (g_bShowLoadDebug && n == 0) {
            System.out.println("Successfully loaded " + System.mapLibraryName(string2));
        }
        if (n != 0) {
            System.err.println("Failed to load " + string2 + " from " + (string != null ? string : " from default location."));
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        g_bShowLoadDebug = false;
        g_osArch = System.getProperty("os.arch");
        g_osName = System.getProperty("os.name");
        if (System.getProperty(DEBUG_KEYWORD) != null) {
            g_bShowLoadDebug = true;
        }
        JIDLPlatform.calcJavaLibLocation();
        JIDLPlatform.calcLibraryLocations();
    }
}

