/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PublicMembers {
    public static void printConstructors(String string) {
        Class clazz = PublicMembers.getClassFromName(string);
        if (clazz != null) {
            PublicMembers.printConstructors(clazz);
        }
    }

    public static String[] getConstructors(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        String[] stringArray = new String[constructorArray.length];
        int n = 0;
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            int n2 = constructor.getModifiers();
            if (!Modifier.isPublic(n2)) continue;
            String string = new String();
            Class<?>[] classArray = constructor.getParameterTypes();
            String string2 = constructor.getName();
            string = Modifier.toString(n2);
            string = string + " " + string2 + "(";
            for (int j = 0; j < classArray.length; ++j) {
                if (j > 0) {
                    string = string + ", ";
                }
                string = string + PublicMembers.convertParamType(classArray[j]);
            }
            string = string + ");";
            stringArray[n++] = string;
        }
        String[] stringArray2 = null;
        if (n > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        return stringArray2;
    }

    private static void printConstructors(Class clazz) {
        String[] stringArray = PublicMembers.getConstructors(clazz);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public static void printMethods(String string) {
        Class clazz = PublicMembers.getClassFromName(string);
        if (clazz != null) {
            PublicMembers.printMethods(clazz);
        }
    }

    public static String[] getMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n2 = method.getModifiers();
            if (!Modifier.isPublic(n2)) continue;
            String string = new String();
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            String string2 = method.getName();
            string = string + Modifier.toString(n2);
            string = string + " " + clazz2.getName() + " " + string2 + "(";
            for (int j = 0; j < classArray.length; ++j) {
                if (j > 0) {
                    string = string + ", ";
                }
                string = string + PublicMembers.convertParamType(classArray[j]);
            }
            string = string + ");";
            stringArray[n++] = string;
        }
        String[] stringArray2 = null;
        if (n > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        return stringArray2;
    }

    private static void printMethods(Class clazz) {
        String[] stringArray = PublicMembers.getMethods(clazz);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public static void printFields(String string) {
        Class clazz = PublicMembers.getClassFromName(string);
        if (clazz != null) {
            PublicMembers.printFields(clazz);
        }
    }

    public static String[] getFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        String[] stringArray = new String[fieldArray.length];
        int n = 0;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            if (!Modifier.isPublic(n2)) continue;
            String string = new String();
            Class<?> clazz2 = field.getType();
            String string2 = field.getName();
            string = string + Modifier.toString(n2);
            string = string + " " + clazz2.getName() + " " + string2 + ";";
            stringArray[n++] = string;
        }
        String[] stringArray2 = null;
        if (n > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        return stringArray2;
    }

    private static void printFields(Class clazz) {
        String[] stringArray = PublicMembers.getFields(clazz);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public static void printSuperclasses(String string) {
        Class clazz = PublicMembers.getClassFromName(string);
        if (clazz != null) {
            PublicMembers.printSuperclasses(clazz);
        }
    }

    private static void printSuperclasses(Class clazz) {
        Class clazz2 = clazz;
        Class clazz3 = clazz2.getSuperclass();
        while (clazz3 != null) {
            String string = clazz3.getName();
            System.out.println(string);
            clazz2 = clazz3;
            clazz3 = clazz2.getSuperclass();
        }
    }

    public static void printAllMembers(String string) {
        Class clazz = PublicMembers.getClassFromName(string);
        if (clazz != null) {
            System.out.println("Class:" + string);
            System.out.println("------ Superclasses:");
            PublicMembers.printSuperclasses(clazz);
            System.out.println("------ Fields:");
            PublicMembers.printFields(clazz);
            System.out.println("------ Ctors:");
            PublicMembers.printConstructors(clazz);
            System.out.println("------ Methods:");
            PublicMembers.printMethods(clazz);
        }
    }

    private static Class getClassFromName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            System.err.println("Class " + string + " not found.");
            clazz = null;
        }
        return clazz;
    }

    private static String convertParamType(Class clazz) {
        return clazz.getName();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("  Usage: java PublicMembers <classname>");
            return;
        }
        String string = stringArray[0];
        PublicMembers.printAllMembers(string);
    }
}

