/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPAL;
import com.idl.javaidl.JIDLProcessInitializer;
import java.io.Serializable;

public class JIDLObject
implements JIDLObjectI,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient JIDLPAL m_interface;
    private String m_sClass;
    private boolean m_isDestroyed;

    protected JIDLObject(String string, String string2) {
        this.m_sClass = string;
        this.m_interface = new JIDLPAL(this, string2);
        this.m_isDestroyed = false;
    }

    protected JIDLObject(String string, int n, String string2) {
        this(string, string2);
    }

    public void createObject() {
        this.createObject(0, null, null, null);
    }

    public void createObject(JIDLProcessInitializer jIDLProcessInitializer) {
        this.createObject(0, null, null, jIDLProcessInitializer);
    }

    public void createObject(int n, Object[] objectArray, int[] nArray) {
        this.createObject(n, objectArray, nArray, null);
    }

    public void createObject(int n, Object[] objectArray, int[] nArray, JIDLProcessInitializer jIDLProcessInitializer) {
        if (this.m_isDestroyed) {
            throw new JIDLException(-1L, "Wrapper has been destroyed.");
        }
        if (this.m_interface != null) {
            this.m_interface.createObject(this.m_sClass, n, objectArray, nArray, jIDLProcessInitializer);
            this.initListeners();
        }
    }

    public void initListeners() {
    }

    public void destroyObject() {
        if (this.m_interface != null) {
            this.m_interface.destroyObject();
        }
        this.m_interface = null;
        this.m_isDestroyed = true;
    }

    public boolean isObjectCreated() {
        boolean bl = false;
        if (this.m_interface != null) {
            bl = this.m_interface.isObjectCreated();
        }
        return bl;
    }

    public boolean isObjectDisplayable() {
        return false;
    }

    public boolean isObjCreated() {
        return this.isObjectCreated();
    }

    public void abort() {
        if (this.m_interface != null) {
            this.m_interface.abort();
        }
    }

    public long getCookie() {
        long l = -1L;
        if (this.m_interface != null) {
            l = this.m_interface.getCookie();
        }
        return l;
    }

    public String getIDLObjectClassName() {
        return this.m_sClass;
    }

    public String getClassName() {
        return this.getIDLObjectClassName();
    }

    public String getProcessName() {
        if (this.m_interface != null) {
            return this.m_interface.getProcessName();
        }
        return "";
    }

    public void setProcessName(String string) {
        if (this.m_interface != null) {
            this.m_interface.setProcessName(string);
        }
    }

    public void callProcedure(String string) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(string, 0, null, null);
        }
    }

    public void callProcedure(String string, int n, Object[] objectArray, int[] nArray) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(string, n, objectArray, nArray);
        }
    }

    public Object callFunction(String string, int n) {
        return this.callFunction(string, 0, null, null, n);
    }

    public Object callFunction(String string, int n, Object[] objectArray, int[] nArray, int n2) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.callFunction(string, n, objectArray, nArray, n2);
        }
        return object;
    }

    public Object getProperty(String string, int n) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.getProperty(string, n);
        }
        return object;
    }

    public void setProperty(String string, Object object, int n) {
        if (this.m_interface != null) {
            this.m_interface.setProperty(string, object, n);
        }
    }

    public String getObjVariableName() {
        return this.getIDLObjectVariableName();
    }

    public String getIDLObjectVariableName() {
        String string = "";
        if (this.m_interface != null) {
            string = this.m_interface.getIDLObjectVariableName();
        }
        return string;
    }

    public Object getIDLVariable(String string) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.getIDLVariable(string);
        }
        return object;
    }

    public void setIDLVariable(String string, Object object) {
        if (this.m_interface != null) {
            this.m_interface.setIDLVariable(string, object);
        }
    }

    public void executeString(String string) {
        if (this.m_interface != null) {
            this.m_interface.executeString(string);
        }
    }

    public void addIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (this.m_interface != null && jIDLOutputListener != null) {
            this.m_interface.addIDLOutputListener(jIDLOutputListener);
        }
    }

    public void removeIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (this.m_interface != null && jIDLOutputListener != null) {
            this.m_interface.removeIDLOutputListener(jIDLOutputListener);
        }
    }

    public void addIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (this.m_interface != null && jIDLNotifyListener != null) {
            this.m_interface.addIDLNotifyListener(jIDLNotifyListener);
        }
    }

    public void removeIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (this.m_interface != null && jIDLNotifyListener != null) {
            this.m_interface.removeIDLNotifyListener(jIDLNotifyListener);
        }
    }

    public String toString() {
        if (this.isObjectCreated()) {
            return "" + this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", process=" + this.getProcessName() + "]";
        }
        return "" + this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", Object not created" + "]";
    }
}

