; Copyright (c) 1998-2023 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	TIF_AMP_PHA_SORT
;
;
;LAST CHANGED: ----------------------------------- 	05 Nov 2023 (aph)

; PURPOSE:
;	This function sorts a folder with mixed amplitude (amp) & phase (pha) files into seperate folders
;
; CATEGORY:
;	    Runs stand alone only
;
; CALLING SEQUENCE:
;   RESULT = tif_amp_pha_sort(file=file, amp_list = amp_list,typ = typ, group_leader=group_leader)
;
; INPUTS: none required
;
; KEYWORDS:
;	FILE	filename
;   AMP_LIST
;   TYP		type ('amp' or 'pha')
;	GROUP_LEADER	would be neded if incorporated into aXis2000
;
; OUTPUTS:typ files are copied to a useer-defined folder

;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (05-Nov-23 aph) first version.developed to analyse MaxIV SoftiMAX ptychography stack output
;                  provided by Jorg Schwenke
;-


function tif_amp_pha_sort, file=file, amp_list = amp_list,typ = typ, group_leader=group_leader
@stack_process_com
@axis_com
@bsif_com
COMMON volume_data, image_stack

on_error,2

defpath = 'Y:\data\XRM\stxm-maxIV\2023\23-10\ptycho\stack_circ_minus\TIF-files'

tmpf = DIALOG_PICKFILE(/Read, FILTER='*.tif',/multiple, path = defpath, $
     title = 'Select tif files in the stack', get_path = defpath) ; , /LPATH, DEFPATH=defpath)
filename_list = tmpf(sort(tmpf))

n_files = n_elements(filename_list)

; --------
; out_file_path = 'Y:\data\XRM\stxm-maxIV\2023\23-10\ptycho\10-05\stack_circ_plus\tif_pha\

; ---- define string of last 3 characters before '.' to be selected
; ----- if not defined in call of this routine

if n_elements(typ) EQ 0 then typ = 'amp'		; default to take amplitude files
;
; do it
;
typ_num = 0
typ_list = strarr(1)
for i = 0, n_files-1 do begin
	file = filename_list(i)
	typ_pos = strpos(file, '.')
	test = strmid(file, typ_pos-3, 3)
;	help, test
	if test EQ typ then begin
		typ_list(typ_num) = filename_list(i)
		typ_list = [typ_list,' ']
		typ_num = typ_num +1
	endif
endfor

print, typ_num,'  ', typ, '  files identified '
print, typ_list

; copy these files to a different folder

outpath = 'Y:\data\XRM\stxm-maxIV\2023\23-10\ptycho\10-05\stack_circ_minus\tif_amp'
for i = 0, typ_num-1 do begin
	t = ax_name(typ_list(i))
	sourcename = typ_list(i)
	outname = outpath + '\' +t(1)+'.' +t(2)
	print, 'Copying ', t(1), '     to     ', outpath
	file_Copy, sourcename, outname
endfor

return, typ_list
end