; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SM_IPAR.PRO
;
;LAST CHANGED: ----------------------------------- 	21 Jul 2014
;
; PURPOSE:
;	This procedure initializes the sm_par structure
;
; CATEGORY:
;	data file formatting
;
; CALLING SEQUENCE:
; for procedures:
;	sm_ipar,sm_par;
;
; INPUTS:
; 	SM_PAR - parameters of SM format
;;
; KEYWORDS: none
;
; COMMON BLOCKS: none;
;
; MODIFICATION HISTORY:
; (27-Jun-01 aph) first entry into aXis2000 (SM is from nsls hdf format I think)
; (21-Jul-14 aph) AXIS standard header added
;-

PRO sm_ipar,sm_par

; These next few lines lines must agree with sm_par.h!
SM_PAR_ADC_PORTS = 8
SM_PAR_DAC_PORTS = 4
SM_PAR_SCALER_PORTS = 8
SM_PAR_MAXPOINTLIST = 25
SM_PAR_STRLEN = 128

IF (n_tags(sm_par) EQ 0) THEN BEGIN
    sm_par = $
      { sm_par, $
        filever: long(0), $ ; set in write_sm.pro
        progver: long(0), $
        col_device: long(0), $
        row_device: long(0), $
        strlen: long(SM_PAR_STRLEN), $
        adc_ports: long(SM_PAR_ADC_PORTS), $
        scaler_ports: long(SM_PAR_SCALER_PORTS), $
        dac_ports: long(SM_PAR_DAC_PORTS), $
        maxpointlist: long(SM_PAR_MAXPOINTLIST), $
        n_cols: long(0), $
        n_rows: long(0), $
        n_data: long(0), $
        prescan_pixels: long(0), $
        shutopen: long(0), $
        bidirectional: long(0), $
        clock_data_channel: long(0), $
        pixel_channels: long(0), $
        n_oneread_channels: long(0), $
        oneread_channels: long(0), $
        n_pointlist: long(0), $
        disp_num_channels: long(0), $
        disp_denom_channels: long(0), $
        disp_raw: long(0), $
	col_pixel_um: float(0), $
	row_pixel_um: float(0), $
        x_center_um: float(0), $
        y_center_um: float(0), $
        z_center_um: float(0), $
	x_pzt_um: float(0), $
	y_pzt_um: float(0), $
	z_pzt_um: float(0), $
	x_stg_um: float(0), $
	y_stg_um: float(0), $
	z_stg_um: float(0), $
	x_det_um: float(0), $
	y_det_um: float(0), $
	z_det_um: float(0), $
	z_osa_um: float(0), $
        col_start_um: float(0), $
        col_stop_um: float(0), $
        row_start_um: float(0), $
        row_stop_um: float(0), $
        start_ev: float(0), $
        stop_ev: float(0), $
        dwell_msec: float(0), $
        ring_gev: float(0), $
        ring_ma: float(0), $
        undulator_gap_mm: float(0), $
        undulator_period_mm: float(0), $
        ens_slit_um: float(0), $
        exs_slit_um: float(0), $
        exsy_slit_um: float(0), $
        sgm_zero_order_steps: float(0), $
        sgm_steps_per_angstrom: float(0), $
        zp_d_um: float(0), $
        zp_delta_nm: float(0), $
        zp_stop_um: float(0), $
        zp_osa_um: float(0), $
        zp_osa_z_um: float(0), $
        tilt_degrees: float(0), $
        xpzt_nm_per_volt: float(0), $
        ypzt_nm_per_volt: float(0), $
        zpzt_nm_per_volt: float(0), $
        xum_per_zum: float(0), $
        yum_per_zum: float(0), $
        clock_hertz: float(0), $
        det1_volt1: float(0), $
        det1_volt2: float(0), $
        det2_volt1: float(0), $
        det2_volt2: float(0), $
        temp1_celsius: float(0), $
        temp2_celsius: float(0), $
        disp_min: float(0), $
        disp_max: float(0), $
        disp_gamma: float(0), $
	disp_num_factors: fltarr(SM_PAR_ADC_PORTS+SM_PAR_SCALER_PORTS+1), $
	disp_denom_factors: fltarr(SM_PAR_ADC_PORTS+SM_PAR_SCALER_PORTS+1), $
        adc_voltsperbit: fltarr(SM_PAR_ADC_PORTS), $
        adc_voltsoffset: fltarr(SM_PAR_ADC_PORTS), $
        dac_voltsperbit: fltarr(SM_PAR_DAC_PORTS), $
        dac_voltsoffset: fltarr(SM_PAR_DAC_PORTS), $
        col_title: bytarr(SM_PAR_STRLEN), $
        row_title: bytarr(SM_PAR_STRLEN), $
        beamline: bytarr(SM_PAR_STRLEN), $
        systime: bytarr(SM_PAR_STRLEN), $
        scientist: bytarr(SM_PAR_STRLEN), $
        sample: bytarr(SM_PAR_STRLEN), $
        comments1: bytarr(SM_PAR_STRLEN), $
        comments2: bytarr(SM_PAR_STRLEN), $
        original_filename: bytarr(SM_PAR_STRLEN), $
        zp_name: bytarr(SM_PAR_STRLEN), $
        temp1_name: bytarr(SM_PAR_STRLEN), $
        temp2_name: bytarr(SM_PAR_STRLEN), $
        scaler_divideby: bytarr(SM_PAR_SCALER_PORTS), $
        adc_channel_names: bytarr(SM_PAR_ADC_PORTS*SM_PAR_STRLEN), $
        scaler_channel_names: bytarr(SM_PAR_SCALER_PORTS*SM_PAR_STRLEN), $
        point_namestr: bytarr(SM_PAR_MAXPOINTLIST*SM_PAR_STRLEN), $
        point_xystr: bytarr(SM_PAR_MAXPOINTLIST*SM_PAR_STRLEN), $
	disp_name: bytarr(SM_PAR_STRLEN),$
        oneread_data: intarr(SM_PAR_ADC_PORTS+SM_PAR_SCALER_PORTS) }
ENDIF

return
end
