; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_AXM.PRO
;
;LAST CHANGED: ----------------------------------- 	31-Jul-11
;
; PURPOSE:
;	This function reads CJJ or Zimba format mapper files (alignment data)
; into two standard 1-d aXis spectral files
;
; CATEGORY:
;	read in .
;
; CALLING SEQUENCE:
; for procedures:
;	ZOOM [, FACT = Fact, /INTERP, XSIZE = Xs, YSIZE = Ys, /CONTINUOUS, $
;		/KEEP, ZOOM_WINDOW=Zoom_Win, /NEW_WINDOW ]
; for functions:
;	Result = READ_AXM(file=file)
;
; INPUTS: none
;
; KEYWORDS:
;	FILE:	filename (if not supplied, routine prompts for one, default extension *.aln)
;
; OUTPUTS:
;	S_X	- aXis 1-d structure with x values as index and y-values as the x-shift
;	S_Y	- aXis 1-d structure with x values as index and y-values as the y-shift
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (15-Jan-99 aph) first version of AXIS-wrapper for Jacobsen read_mapper routine
; (31-Jul-11 aph) AXIS standard header added
;-

PRO READ_AXM, file = file, s_x, s_y

on_error,2
@axis_com

null=''

if NOT keyword_set(file) then begin
	map_file = pickfile2(/read,filter='*.aln', DEFPATH=DefPath, /Lpath)
	if map_file EQ '' then return
endif else map_file = file

zstack_read_mapper, map_file, t_x, t_y
dln = ax_name(map_file)
y = reform(t_y(0, *))
s_x={t:'1d', d: y, x: t_x, xl: 'x', dn: y, dl:dln(1) + ' x'}
y = reform(t_y(1, *))
s_y={t:'1d', d: y, x: t_x, xl: 'x', dn: y, dl:dln(1) + ' y'}

axis_log, 'Read alignment file from ' + dln(1)
return

END