; Copyright (c) 1998-2010 J. Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_AADATA.PRO
;
;LAST CHANGED: ----------------------------------- 	19-Jul-10
;
; PURPOSE:
;	This function reads the data from a file  containing
; an amino acid spectrum, name, and chemical composition
;
; CATEGORY:
;	Utility; part of XSpecSim, spectral simulator package
;
; CALLING SEQUENCE:
;	Result = read_AAData (file=file, filter=filter, letter=letter, engdat=engdat, comp=comp)
;
; INPUTS: none
;
; KEYWORDS:
;	FILE	file name
;	FILTER	extension filter
;	LETTER	element of interest
;	ENDGAT	UNDEFINED AND UNUSED
;	COMP	composition in terhms of numbers of H,C,N,O,S,P
;
; OUTPUTS:
;
;COMMON BLOCKS:
;	XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added;
;                 axis_com and XSpecSim_com added
;-

function read_AAData, file=file, filter=filter, letter=letter, engdat=engdat, comp=comp
@XSpecSim_Com

if not keyword_set(file) then begin
	filter='*.txt'
	file_e = pickfile2(Title='Select AA File', /READ, FILTER=filter, /LPATH)
endif else file_e = file
if strlen(file_e(0)) eq 0 then return, s
t = ax_name(file_e)
check=findfile(file_e)
openr, iunit, file_e, /get_lun
test= ''
pos=0
while pos NE -1 do begin
	readf, iunit, test
	pos = strpos(test,'#')
	posb = strpos(test, 'LETTER:')
	if posb NE -1 then begin
		letter=strtrim(strmid(test,posb+8,3),2)
	endif
	posc = strpos(test, 'Composition:')
	if posc NE -1 then begin
		Comp = ParseComposition(strdat=strtrim(strmid(test,posc+12,strlen(test)-posc+12),2))
	endif
endwhile
ans=fltarr(2, 10000)
test = strtrim(test,2)
t=parsestring(test)
ans(*,0)=	t
j=long(1)
while not eof(iunit) do begin
	readf, iunit, test
	test = strtrim(test,2)
	t=parsestring(test)
	ans(*,j)=	t
	j=j+1
endwhile
ans=ans(*,0:j-1)
close, iunit & free_lun, iunit
return, ans
end