; $Id: photon_conv.pro,v 1.1 1997/12/16 02:04:29 loo Exp $ 
; 
;+ 
; NAME: 
;       WVLEN2EN, EN2WVLEN 
; 
; PURPOSE: 
;       These functions convert between photon energy and wavelength. 
; 
; CATEGORY: 
;       Optics 
; 
; CALLING SEQUENCE: 
;       Wavelength = EN2WVLEN(Energy) 
; 
; INPUTS: 
;       Input:  The photon energy to convert. 
; 
; KEYWORD PARAMETERS: 
;       m:        If set, wavelength is in meters. This is the default. 
; 
;       nm:       If set, wavelength is in nanometers. 
; 
;       Angstrom: If set, wavelength is in Angstroms. 
;  
;       J:        If set, photon energy is in Joules. This is the default. 
; 
;       keV:      If set, photon energy is in kiloelectron Volts. 
; 
;       eV:       If set, photon energy is in electron volts. 
; 
; OUTPUTS: 
;       Result:  The conversion of photon energy to wavelength. 
; 
; WRITTEN BY: 
;       Billy W. Loo, Jr. 
;       Bioengineering Graduate Group, UCSF / UCB 
;       School of Medicine, UCD 
;       Lawrence Berkeley National Lab 
;       December, 1997 
;- 
; 
; MODIFICATION HISTORY: 
; 
; $Log: photon_conv.pro,v $ 
; Revision 1.1  1997/12/16 02:04:29  loo 
; Initial revision 
; (14-nov-00 cgz) migrated from PHOTON_CONV.PRO
; 
 
FUNCTION EN2WVLEN, energy, M=m, NM=nm, ANGSTROM=angstrom, $ 
                           J=j, KEV=kev, EV=ev 
  ;Convert energy to Joules. 
  IF KEYWORD_SET(keV) THEN en = energy * 1.6021892E-16     $ ;(J/keV) 
  ELSE IF KEYWORD_SET(eV) THEN en = energy * 1.6021892E-19 $ ;(J/eV) 
  ELSE en = energy 
   
  h = 6.626176E-34 ;Planck's constant (Js) 
  c = 2.99792458E8 ;Speed of light (m/s) 
   
  wavelength = h * c / en 
 
  ;Convert wavelength to desired units. 
  IF KEYWORD_SET(nm) THEN wavelength = wavelength * 1E9 $ 
  ELSE IF KEYWORD_SET(angstrom) THEN wavelength = wavelength * 1E10 
 
  RETURN, wavelength 
END ;en2wvlen 
