;+ 
; NAME: 
;       CIndex 
; 
; PURPOSE: 
;       This is a program for viewing the current colors in the 
;       colortable with their index numbers overlayed on each color. 
;       On 24-bit systems you must click the cursor in the graphics window 
;       to see the colors in the current color table. 
; 
; AUTHOR: 
;       FANNING SOFTWARE CONSULTING 
;       David Fanning, Ph.D. 
;       2642 Bradbury Court 
;       Fort Collins, CO 80521 USA 
;       Phone: 970-221-0438 
;       E-mail: davidf@dfanning.com 
;       Coyote's Guide to IDL Programming: http://www.dfanning.com 
; 
; CATEGORY: Graphics 
; 
; CALLING SEQUENCE:  CIndex 
; 
; INPUTS:   None. 
; 
; Optional Inputs:   None 
; 
; OUTPUTS:  None 
; 
; OPTIONAL OUTPUTS:  None 
; 
; KEYWORD Parameters:   None 
; 
; COMMON BLOCKS:  None 
; 
; SIDE EFFECTS:   None 
; 
; RESTRICTIONS:   Reqires XCOLORS from the Coyote Library: 
; 
;                     http://www.dfanning.com/programs/xcolors.pro 
; 
; PROCEDURE: 
; 
;  Draws a 31x25 set of small rectangles in 256 different colors. 
;  Writes the color index number on top of each rectangle. 
; 
; MODIFICATION HISTORY:  David Fanning, RSI, May 1995 
; 
;  Widgetized and made it work in 24-bit color. Colors are 
;     updated by clicking in window. 22 Oct 98. DWF 
; 
;  Replace POLYFILL with TV command to avoid underflow error in 
;     Z-buffer. 8 March 99. DWF 
;- 
 
PRO CIndex_Colors, event 
 
Widget_Control, event.top, Get_UValue=info, /No_Copy 
 
   ; What kind of event is this? 
 
thisEvent = Tag_Names(event, /Structure_Name) 
CASE thisEvent OF 
 
   'WIDGET_BUTTON': XColors, Group_Leader=event.top, $ 
      NotifyID=[event.id, event.top] 
 
   'XCOLORS_LOAD': BEGIN 
      Device, Get_Visual_Depth=thisDepth 
      IF thisDepth GT 8 THEN BEGIN 
         thisID = !D.Window 
         WSet, info.wid 
         TV, info.snap 
         WSet, thisID 
      ENDIF 
 
      ENDCASE 
ENDCASE 
Widget_Control, event.top, Set_UValue=info, /No_Copy 
END 
;--------------------------------------------------------------------- 
 
 
 
PRO CIndex_Event, event 
IF event.type NE 1 THEN RETURN 
Widget_Control, event.top, Get_UValue=info, /No_Copy 
thisID = !D.Window 
WSet, info.wid 
TV, info.snap 
WSet, thisID 
Widget_Control, event.top, Set_UValue=info, /No_Copy 
END 
 
PRO CIndex 
oldWindowID = !D.Window 
thisDevice = !D.Name 
Set_Plot, 'Z' 
Device, Set_Resolution=[496,400] 
 
   ; Set the starting index for the polygons. 
 
xindex = 0 
yindex = 0 
 
   ; Start drawing. There are 16 rows and 16 columns of colors. 
 
FOR i=0,15 DO BEGIN 
 
    y = [yindex, yindex+25, yindex+25, yindex, yindex] 
    yindex = yindex+25 
    xindex = 0 
 
    FOR j=0,15 DO BEGIN 
 
        x = [xindex, xindex, xindex+31, xindex+31, xindex] 
        color = j+(i*16) 
 
           ; Draw the polygon in a specfic color. 
 
        ;Polyfill, x, y, /Device, Color=color 
        TV, Replicate(color,31,25), j*31, i*25 ; To avoid bug in Z-buffer. 
        output = StrTrim(j+(i*16), 2) 
 
           ; Draw the index number in the "opposite" color. 
 
        XYOutS, xindex+8, yindex-15, output, Color=Byte(255-color), $ 
           /Device, Charsize=0.75 
 
           ; Reset the xindex number. 
 
        xindex = xindex+31 
 
    ENDFOR 
 
ENDFOR 
 
   ; Take a snapshot of the Z-Buffer. 
 
snap = TVRD() 
 
Set_Plot, thisDevice 
Device, Decomposed=0 
 
tlb = Widget_Base(Title='Color Index Numbers', $ 
   TLB_Frame_Attr=1, MBar=menuID) 
controlID = Widget_Button(menuID, Value='Change Colors') 
xcolorsID = Widget_Button(controlID, Value='XColors', $ 
   Event_Pro='CIndex_Colors') 
drawID = Widget_Draw(tlb, XSize=496, YSize=400, /Button_Events) 
Widget_Control, tlb, /Realize 
Widget_Control, drawID, Get_Value=wid 
WSet, wid 
TV, snap 
 
info = {snap:snap, wid:wid} 
Widget_Control, tlb, Set_UValue=info, /No_Copy 
WSet, oldWindowID 
XManager, 'cindex', tlb, /No_Block 
END 
