; Copyright (c) 2004-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_SLICER3
;
;LAST CHANGED: ----------------------------------- 	17-Sep-08
;
; PURPOSE:
;	This procedure reads a stack in *.ncb format into slicer3
;
; CATEGORY:
;	3d image display.
;
; CALLING SEQUENCE:
;	AX_SLICER3
;
; INPUTS: none
;
; KEYWORDS:  none
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;  stack_process_com
;	volume_data  - image stack
;
; MODIFICATION HISTORY:
; (21-feb-06 aph) AXIS standard header added
; (17-Sep-08 aph) replace analcom with stack_process_com
;-


PRO ax_slicer3
@axis_com
@bsif_com
@stack_process_com
COMMON volume_data, image_stack


; ------- get binary stack file

	stack_rb
	cpos = strpos(filename_ev_msec_list(0),':')
	filename_list = strarr(n_elements(filename_ev_msec_list))
	for i = 0, n_elements(filename_list)-1 do begin
		filename_list(i) = strmid(filename_ev_msec_list(i),0,cpos-1)
	endfor
; ---------- start slicer3
	hData = PTR_NEW(image_stack, /NO_COPY)
	slicer3, hdata, DATA_NAMES='Stack', /modal
	if PTR_VALID(hdata) then PTR_FREE, hdata		; clean up pointers !

	END
