; Copyright (c) 1998-2021 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_IMG_line
;
;LAST CHANGED: ----------------------------------- 08 Oct 2021 (aph)
;
; PURPOSE:
;	This procedure replaces all pixels in a user-selected line (row, or column)
; with those of another user-selected line (or average of 2 adjacent lines) (row, or column)
;
; CATEGORY:
;	AXIS: image analysis
;
; CALLING SEQUENCE:
;	AX_IMG_line
;
;CALLED FROM AXIS:
;	->Images->Delete region, after user clicks on a line

; INPUTS:
;	All input parameters are passed as keywords or through AXIS_COM
;
; KEYWORDS: none
;
; OUTPUTS:
;	Modified image placed in buffer 0.
;
; COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
 ; RESTRICTIONS:
;	only executable from AXIS
;
; MODIFICATION HISTORY:
; (29-dec-01 aph) first written
; (20-Jan-05 aph) add ability to define the y-index of line to be changed
; (08-Oct-21 aph) adapt for replacing vertical lines
;-

PRO ax_img_line, horizontal = horizontal, vertical = vertical

@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t NE '2d' THEN BEGIN
	WIDGET_CONTROL, Uprompt, Set_Value = 'Image~replace line: only for images'
	return
ENDIF


;  use cursor to identify line
;   WIDGET_CONTROL, Uprompt, SET_VALUE='use cursor to select line to be replaced'
;	CURSOR, xc, yc, /UP, /Data
;	ind = Dindex(xc,yc,tmp)

If keyword_Set(horizontal) then begin

	badrow = CurY
	; ---------------- confirm line number to modify ---------------
	badrow = get_num(prompt = 'line to replace ?', val = badrow, group = axis_ID)
	; ---------- decide which line to use for replqcement ----------------
	avg_lin = dialog_message(/question,'Average adjacent rows ? ', title='ROW replacement')
	if avg_lin  EQ 'Yes' then begin
		tmp.d(*,badrow) = (tmp.d(*,badrow-1)+ tmp.d(*,badrow+1))/2
		print, 'replaced row', badrow, ' with average of adjacent rows'
	endif else begin
		goodrow = get_num(prompt = 'replacement row ?', val = badrow+1, group = axis_ID)
		tmp.d(*,badrow) = tmp.d(*,goodrow)
		print, 'replaced row', badrow, ' with row ', goodrow
	endelse
	ax_color
	CurBuf = 0
	tmp.dl = 'RR ' + tmp.dl
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	PlotBuf, CurBuf
	Label(CurBuf) = tmp.dl
	img_rep_line = 0
ENDIF

IF keyword_Set(vertical) then begin
	badcol = CurX
	; ---------------- confirm line number to modify ---------------
	badcol = get_num(prompt = 'line to replace ?', val = badcol, group = axis_ID)
	; ---------- decide which column to use for replqcement ----------------
	avg_lin = dialog_message(/question,'Average adjacent columns ? ', title='COLUMN replacement')
	if avg_lin  EQ 'Yes' then begin
		tmp.d(badcol,*) = (tmp.d(badcol-1,*) + tmp.d(badcol+1,*))/2
		print, 'replaced column', badcol, ' with average of adjacent columns'
	endif else begin
		goodcol = get_num(prompt = 'replacement column? ', val = badcol+1, group = axis_ID)
		tmp.d(badcol,*) = tmp.d(goodcol,*)
		print, 'replaced column ', badcol, ' with column ', goodcol
	endelse
	ax_color
	CurBuf = 0
	tmp.dl = 'RC ' + tmp.dl
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	PlotBuf, CurBuf
	Label(CurBuf) = tmp.dl
	img_rep_line = 0

ENDIF

END
