; Copyright (c) 2025-2025 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	READ_ISEELS
;
;LAST CHANGED: -----------------------------------  05 Jun -2025 (aph)
;
;PURPOSE:
;	This function converts unformatted (binary) ISEELS spectra (*. (no extension)  usually)
;   to text-formatted (2-column real) or AXIS2000 (*.txt) ascii format.
;
;CATEGORY:
;	STAND ALONE: utility & may be called from aXis2000
;
;CALLING SEQUENCE:
;	Result =  READ_ISEELS (file,outfile,outtype)
;
;CALLED FROM AXIS:
;	Write->AXIS
;
;INPUTS:
;  unformatted (binary) ISEELS spectra (*.)	file
;
;KEYWORDS
;	FILE - name of unformatted (binary) ISEELS spectra (*.)	file
;   OUTFILE - name of output file
;	OUTTYPE - predefine out type (iseels

;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (11-Apr-25 aph) first version - did not work
; (05-Jun-25 aph) 2nd try, with BAN code (Fortran77) for unformatted write

FUNCTION read_iseels, file, outfile, outtype

; ----------------- structure of ISEELS text files written by BAN
;EITHER
;	%Start Time: 8:15 PM 7/8/13
;	%End Time: 9:32 PM 7/8/13
;	%Number of Scans: 30
;	%Start and End Pressure: 2.25E-6, 2.20E-6
;	%Start and End Current and Scale(uA): 2, 2, 5
;	277.887	267.000
;	278.086	272.000
;   . . . . ..
;
; OR just
;	277.887	267.000
;	278.086	272.000

; OR
;  if (writef(fn,npts,x,y,chstat).ne.0) goto 999 (error message)
; where 	fn = 40 characters (header)   ; same as fn30(1)
;			npts = integer (#of data points
;			x, y = x and y values at ech point (reals)
;			chstat = 3 character
;
;
;   . . . . ..

; ----------- aXis2000 spectrum structure
;  s={t:'1d', d:d, x: x, xl: '', dn: d, dl: 'text'}

s=1

; ----------- using ReadU  with approach used in read_bessy_txm does not work; data is not text
;OPENR, iunit, file, /GET_LUN
;a=''
;WHILE(~ EOF(iunit)) DO BEGIN
;	READU,iunit,a
;	help, a
;	print, a
;;	b = strsplit(a,' ',/extract)
;;	print, b
;
;
;ENDWHILE
;close,iunit & free_lun, iunit
;
;return, s
;end

; ----------------------
;if n_elements(file) EQ 0 then

file=pickfile2()

; ---------------------- read header
;a = ' '
;openr, iunit, file, /get_lun		; , /F77_UNFORMATTED
;  when tried to use  /F77_UNFORMATTED IDL returned: ERROR  READU: Corrupted f77 unformatted file detected
;  so likely NOT /F77 unformated.

; -------------- determnie number of lines
;nl = 0
;t = 0
;WHILE(~ EOF(iunit)) DO BEGIN
;	READU, iunit, a ;,/transfer_count=t
;	nl = nl+1
;	print, 'line ',nl, '     #elements ',t
;
;;	help, a
;;	print, a
;;;	b = strsplit(a,' ',/extract)
;;;	print, b
;ENDWHILE

a = ' '
openr, iunit,   file, /get_lun    ; /F77_UNFORMATTED,
n_bytes = ulong(100)
READU, iunit,n_bytes
print, 'byte count = ', n_bytes
fn = string(40)
READU, iunit, fn
PRINT, 'header = ', fn
npts = 0
READU, iunit, npts
; npts = 44					; kluge
PRINT, '# of points = ', npts
x = fltarr(npts)
y = fltarr(npts)
help, x, y
xn = 0.
yn = 0.
for i = 0, npts-1 do begin
	READU, iunit,  xn, yn
	x(i) = xn			;  x,y seem swapped
	y(i) = yn
	PRINT,  x(i), y(i)
endfor

; print, 'TOTAL # of lines = ', nl

;for i=0,4 do begin
;	readu, iunit, a		;,  /F77_UNFORMATTED (suggested in esci386_lesson07_basic_input_output.pdf) NO GO
;	print, a
;endfor
;; ---------------------  read (e,d) pairs
;help, np

;ne = fix(np(0) - 5.)
;
;e = fltarr(ne)  &  d = fltarr(ne)
;
;for i=0, ne-1 do begin
;	readu, iunit, e(i), d(i)
;	print, e(i), '   ', d(i)
;endfor
close, iunit
free_lun, iunit

 return, s
end

;; --------- write out spectrum
;if n_elements(outfile) EQ 0 then begin
;	outfile = pickfile2(title='output file', outfile=file)
;endif
;
;; ------- define type
;;check = 'Yes'
;;if n_elements(outtype) EQ 0 then begin
;;	check = dialog_message('write as 2-col (No) or aXis2000 (Yes) format?', /QUESTION)
;;endif else begin
;;	if  strlowcase(outtype) EQ 'iseels' then check = 'No'
;;endelse
;;
;;if check EQ 'No' then begin
;;; ---------- write as formatted 2 column text file, with (energy, intensity)
;;	openw, iunit, out_file, /get_lun
;;	for i = 0, np-1 do printf, iunit, se(i), '  ',d(i)
;;	close, iunit
;;endif else begin
;
;; --------- write as aXis2000 format file with header
;;  ------- generate aXis2000 spectrum file
;;	t=ax_name(file)
;;	s={t:'1d', d:d, x:e, xl:'Energy loss (eV)', dn:d, dl:t(1)}
;;	t =ax_name(outfile)
;;	outfile = t(0) + t(1) +'.txt'
;;	f = spc_save (s, file = outfile)   ;  silent=silent, noheader=noheader, noLbl = noLbl, NOF=nof)
;;endelse
;
;;-----------------
;print, 'unformatted ', t(2), ' saved as', outfile
; return, s
;end