; Copyright (c) 2001 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_SHIFT_IMAGES
;
;LAST CHANGED: ----------------------------------- 5-dec-01
;
; PURPOSE:
;	This function rotates and shifts a single image by the
; values contained in user-supplied variables, or from user dialog.
;
; CATEGORY:
;	stand alone ; AXIS: stack analysis
;
; CALLING SEQUENCE:
; ax_shift_images, angle=angle, xshift=xshift,yshift=yshift
;
; INPUTS:
;	IMAGE  - reference image
;	ANGLE   - rotation angle (clock-wise)
;	XSHIFT 	- value of x-shift (in fractional pixels)
;	YSHIFT  - value of y-shift (in fractional pixels)
;
; KEYWORDS: none
;
; OUTPUTS:
;	shifted image
;
; COMMON BLOCKS:
;   bsif_common
;
; MODIFICATION HISTORY:
; (04-dec-01 aph) adapted from zstack_align
;-

Function ax_shift_image,image,angle, xshift, yshift
@bsif_common

; ------- ask user for angle, xshift, yshift if not in call

;if not keyword_set(angle)then $
;	angle = get_num(prompt = 'angle (degrees)', val = angle)
; if not keyword_set(xshift)then $
;	xshift = get_num(prompt = 'X-shift (pixels)', val = xshift)
; if not keyword_set(yshift)then $
;	yshift = get_num(prompt = 'Y-shift (pixels)', val = yshift)

p = [xshift,0.,1.,0.]
q = [yshift,1.,0.,0.]

missing = median(image)

if angle NE 0 then begin
	image = ROT(image, angle,1.0, /INTERP, $  ;ind(0)+n_xoff, ind(1)+n_yoff,
     missing = missing, /pivot)    ; angle in DEGREE CLOCKWISE
endif

new_image = poly_2d(image,p,q,2,missing=missing,cubic=-0.5)

return, new_image

end