; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	THUMBZOOM 
; 
;LAST CHANGED: ----------------------------------- 19-dec-00 
; 
;PURPOSE: 
;	This procedure plots 4 or 9 buffers in the main image of AXIS 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	ThumbZoom [, NUM=num , BufChoice=Buf4, color=color, all_scale=all_scale] 
; 
;CALLED FROM AXIS: 
;	->Zoom->Thumbnails->{4->{B/W,color},9->{B/W,color}} 
 
;INPUTS: 
;	All input parameters are passed as keywords or by AXIS_COM. 
; 
;KEYWORDS: 
;	NUM = 4 - display four user-selected buffers ( =9 - all buffers) 
;	BUFCHOICE - indices of the selected buffers 
;	COLOR - display images with current color table, spectra with AXIS_COLORS 
;	ALL_SCALE - scale images by min/max of all displayed images 
; 
;OUTPUTS: 
;	The composite image is generated as an AXIS 2d structure in bufer = 10. 
; All image options should execute on this composite image 
; USE COPY to write multi-image display to a single buffer 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (xx-MAR-98 aph) split from axis_c 
; (14-jun-98 aph) axis_com 
; (24-jun-99 aph) go for consistent color ! 
; (29-jun-99 aph) correct name for axis_color_common variables 
; (10-jul-99 aph) add B/W or color option to assist printing 
; (26-sep-99 aph) split from Thumbs.pro to have filename = pro name 
; (01-Jan-00 aph) generate mega-image for lineouts 
; (01-jan-00 aph) AXIS standard documentation 
; (30-nov-00 cgz) Replaced call of wdivide with explicit !p.multi statement
;			Replaced IF NUM EQ # staements with CASE structure
; (19-dec-00 cgz) substituted ax_white_color_index with ax_plot_axes_color_index
;			substituted ax_black_color_index with ax_plot_bkgd_color_index
;- 
 
PRO ThumbZoom, NUM=num , BufChoice=Buf4, color=color, all_scale=all_scale 
@axis_com
on_error, 2 
 
WIDGET_CONTROL,/hourglass 
CurBuf0 = CurBuf   ; save last buffer # 
WSET, MainImg 
if not keyword_set(num) then num = 9      ; default to 3x3 (p buffers) 
;if num eq 9 then rc = 3 
;if num eq 4 then rc = 2 
CASE num OF
	16 : BEGIN
		rc = 4
	END
	9 : BEGIN
		rc = 3
	END
	4 : BEGIN
		rc = 2
	END
	ELSE : BEGIN
		print,'THUMBZOOM : unknown rc'
		rc = 1
	END
ENDCASE
;wdivide, rc, rc 
!p.multi = [0,rc,rc]
Msiz=360            		;  Main Image Size is 360 x 360   (**** change as needed ****) 
erase 
; print in B/W (gamma=0.5) to get round print problem ---------- KLUGE !! (aph 10-jul-99) 
if NOT keyword_set(color) then loadct,0 
siz = fix(Msiz*gr_scale/rc)		; determine box sizes 
bgndcol = ax_plot_axes_color_index	;ax_white_color_index  ; WHITE background 
buf = indgen(num) + 1 
if num eq 4 then begin 
 buf(2) = 4 & buf(3) = 5 
endif 
if keyword_set(Buf4) then buf = Buf4 
PBufs=intarr(num)  ;define the array to store Buffer #s 
; --------- generate full data image in pixel units 
img_min = 1e+20 & img_max = -1e+20	; global min/max 
d_all = fltarr(rc*siz,rc*siz) 
FOR i = 0, num-1 DO BEGIN 
    HANDLE_VALUE, Data(buf(i)), tmp 
    IF n_tags(tmp) NE 0 THEN BEGIN 
   	  IF tmp.t EQ '2d' then begin 
		this_img_min = min(tmp.d, max = this_img_max) 
		if this_img_min LT img_min then img_min = this_img_min 
		if this_img_max GT img_max then img_max = this_img_max 
		k = 1 + i MOD rc       ; row of split image 
		j = 1 + fix(i/rc)	   ; col of split image 
		j = rc+1-j 
		b = congrid(tmp.d,siz,siz, /INTERP) 
		d_all((k-1)*siz:k*siz-1,(j-1)*siz:j*siz-1) = b 
	  ENDIF 
	ENDIF 
ENDFOR 
FOR i = 0, num-1 DO BEGIN			; fill rest of image array with img_min 
    HANDLE_VALUE, Data(buf(i)), tmp 
    IF n_tags(tmp) NE 0 THEN BEGIN 
   	  IF tmp.t NE '2d' then begin 
		k = 1 + i MOD rc       ; row of split image 
		j = 1 + fix(i/rc)	   ; col of split image 
		j = rc+1-j 
		d_all((k-1)*siz:k*siz-1,(j-1)*siz:j*siz-1) = img_min 
	  ENDIF 
	ENDIF 
ENDFOR 
; ----------------- generate single image for lineouts and scaling 
CurBuf0 = 10 
t_xy = findgen(rc*siz) 
dl = 'composite image' 
tmp = {t:'2d', x:t_xy, y:t_xy, xl:'X (pixels)',yl:'Y (pixels)',d:d_all, dl:dl} 
HANDLE_VALUE, Data(CurBuf0), tmp, /set 
Xrng(0) = tmp.x(0)  & Xrng(1) = tmp.x(n_elements(tmp.x)-1) 
Yrng(0) = tmp.y(0)  & Yrng(1) = tmp.y(n_elements(tmp.y)-1) 
Zrng(0) = img_min   & Zrng(1) = img_max 
 
; ------------------- generate display  --------------- 
  FOR i = 0, num-1 DO BEGIN 
    CurBuf = buf(i) 
    pBufs(i) = CurBuf 
	HANDLE_VALUE, Data(CurBuf), tmp 
  	IF n_tags(tmp) NE 0 THEN BEGIN    ; ONLY PROCESS IF THERE IS DATA 
	  	!X.S = Xscl(CurBuf,*)   	      ; restore image (x,y,z) scaling parameters 
	    !Y.S = Yscl(CurBuf,*) 
	    !Z.S = Zscl(CurBuf,*) 
  		CASE tmp.t OF 
  		'3d' : begin 
  			b = congrid(ax_imscl(tmp.d),siz,siz, /INTERP) 
  			tv,b,i 
  		  end 
 
  		'2d' : begin 
  			make_square,tmp 
  			if keyword_set(all_scale) then begin 
  			   	t_12 = ax_imscl([tmp.d(0,0),tmp.d(0,1),img_min,img_max]) 
 			   	tmp.d(0,0) = img_min  & tmp.d(0,1) = img_max 
  			   	t_d = ax_imscl(tmp.d) 
  			   	t_d(0,0) = t_12(0) & t_d(0,1) = t_12(1) 
  			   	b = congrid(t_d,siz,siz, /INTERP) 
  			endif else  b = congrid(ax_imscl(tmp.d),siz,siz, /INTERP) 
  			tv,b,i 
  		  end 
 
  		'1d' : begin 
   			j = 1 + i MOD rc       ; row of split image 
  			k = 1 + fix(i/rc)	     ; col of split image 
  		    xydat = convert_coord(tmp.x, tmp.d, /to_device) 
  		    x1 = siz*(j-1)    &  y1 = siz*(rc-k) 
  		    x2 = siz*j        &  y2 = siz*(rc+1-k) 
  		    if keyword_set(color) then tmp_color = bcolor(CurBuf) $ 
  		       else tmp_color = ax_plot_bkgd_color_index	;ax_black_color_index 
  		    polyfill,[x1,x2,x2,x1],[y1,y1,y2,y2],color=bgndcol, /device 
			plot,xydat(0,*), xydat(1,*),/device, background=bgndcol, $ 
			  position = [x1,y1,x2,y2], xstyle=5, ystyle=5,psym=Line_sym, $ 
			  xmargin=[1,1],ymargin=[1,1], color=tmp_color, thick=1, /noerase 
     		end 
       ENDCASE 
     endif else begin 
  ; PLOT blank field  if no data 
  		b = intarr(siz,siz) 
		tv,b,i 
	 endelse 
   ENDFOR 
   gridcol = 0 
   if num eq 9 then begin 
     	siz2 = 2*siz   &  siz3 = 3*siz-1 
  		plots,[siz,siz],[0,siz3],/device,color=gridcol    ; refresh grid 
  		plots,[siz2,siz2],[0,siz3],/device,color=gridcol 
  		plots,[0,siz3],[siz,siz],/device,color=gridcol 
  		plots,[0,siz3],[siz2,siz2],/device,color=gridcol 
  		plots,[0,0],[0,siz3],/device,color=gridcol 
  		plots,[0,siz3],[siz3,siz3],/device,color=gridcol 
  		plots,[siz3,siz3],[siz3,0],/device,color=gridcol 
  		plots,[0,siz3],[0,0],/device,color=gridcol 
  	endif else begin 
  		siz2 = 2*siz - 1 
  		plots,[siz,siz],[0,siz2],/device,color=gridcol    ; refresh grid 
  		plots,[0,siz2],[siz,siz],/device,color=gridcol 
  		plots,[0,0],[0,siz2],/device,color=gridcol 
  		plots,[0,siz2],[siz2,siz2],/device,color=gridcol 
  		plots,[siz2,siz2],[siz2,0],/device,color=gridcol 
  		plots,[0,siz2],[0,0],/device,color=gridcol 
  	endelse 
  	CurBuf = CurBuf0 
; indicate buffers plotted 
	For i = 0, 9 DO BufStat(i) = 0   ;indicate the buffers plotted 
	For i = 0, num-1 DO BufStat(pBufs(i)) = 1 
	WIDGET_CONTROL, BufButs, SET_VALUE = BufStat 
  	wset, MainImg 
; 	wdivide,0,0 
	!p.multi=[0, 1, 1] 
; set paramaters to indicate THUMBZOOM (so can identify & clear the adjusted color tables etc) 
	click1 = 0 
	Thumb_plot = 1 
	First = 1 
END 
 
