; Copyright (c)2006-2007 Jacob Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;		LENGTH.PRO
;
;LAST CHANGED: -----------------------------------  09-Mar-07
;
; PURPOSE:
;	This  function Returns the length of a vector (or array) based on the assumption
; that the largest index represents the length
;
; CATEGORY:
;	utility, part of XSpecSim
;
;
; CALLING SEQUENCE:
;	Result = LENGTH(VEC)
;
; INPUTS:
;	VEC = VECTOR
;
; KEYWORDS: none
;
; OUTPUTS: none
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (07-jul-06 jso) last version supplied
; (09-mar-07 aph) AXIS standard header added, name changed
;-

function Length,vec
; Returns the length of a vector (or array) based on the assumption
; that the largest index represents the length

  s = Size(vec)
  len = Max(s[1:s[0]])

  Return,len
end