; $Id: file2string.pro,v 1.1 1997/06/04 17:43:16 loo Exp $ 
; 
;+ 
; NAME: 
;       FILE2STRING 
; 
; PURPOSE: 
;       This function reads the contents of a text file into a string array, 
;       one line per element. 
; 
; CATEGORY: 
;       Input / Output 
; 
; CALLING SEQUENCE: 
;       Out_string = FILE2STRING(Filename, Count) 
; 
; INPUTS: 
;       Filename:     The name of the text file from which to read string data. 
; 
; KEYWORD PARAMETERS: 
;       COMMENT_CHAR: A string containing a single character used to 
;                     identify comments. If a line in the text file  
;                     starts with the comment character, it is not read. 
; 
; OUTPUTS: 
;       Out_string:   The string array containing the lines of the text file. 
; 
;       Count:        A named variable to receive the number of lines read. 
; 
; WRITTEN BY: 
;       Billy W. Loo, Jr. 
;       Bioengineering Graduate Group, UCSF / UCB 
;       School of Medicine, UCD 
;       Lawrence Berkeley National Lab 
;       May, 1997 
;- 
; 
; MODIFICATION HISTORY: 
; 
; $Log: file2string.pro,v $ 
; Revision 1.1  1997/06/04 17:43:16  loo 
; Initial revision 
; 
 
FUNCTION FILE2STRING, filename, count, COMMENT_CHAR=comment_char 
  ;Open file for reading. 
  OPENR, lun, filename, /GET_LUN 
 
  ;Initialize output variable. 
  out_string = '' 
 
  ;Read in the file as strings, line by line. 
  WHILE NOT(EOF(lun)) DO BEGIN 
    line = '' 
    READF, lun, line 
 
    IF KEYWORD_SET(comment_char) THEN BEGIN 
      ;If first character of line is the comment character, reject the line. 
      IF (STRING((BYTE(line))(0)) NE comment_char) THEN $ 
        out_string = [out_string, line] 
    ENDIF $ 
 
    ELSE out_string = [out_string, line] 
  ENDWHILE 
 
  ;Close file. 
  CLOSE, lun 
  FREE_LUN, lun 
 
  ;Prune off leading blank. 
  IF (N_ELEMENTS(out_string) GT 1) THEN out_string = out_string(1:*) 
 
  ;If only one element, convert to scalar. 
  count = N_ELEMENTS(out_string) 
  IF (count EQ 1) THEN out_string = out_string(0) 
 
  RETURN, out_string 
END ;file2string 
