; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	BNL_LOAD 
; 
;LAST CHANGED: ----------------------------------- 23-feb-00 
; 
;PURPOSE: 
;	This function loads  spectral data from the nsls X1A 
; standard ASCII format file into AXIS 1d data structure 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	Result = BNL_LOAD(NOF=nof, DEFPATH=DefPath) 
; 
;CALLED FROM AXIS: 
;	->Read->NSLS->ascii 
; 
;INPUTS: 
;	All input parameters are passed as keywords. 
; 
;KEYWORDS: 
;	NOF - no filter 
;   DEFPATH - default path (used in pickfile routine) 
; 
;OUTPUTS: 
;	The result is placed in the Current Buffer. 
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; (aph 7-aug-97) broke out of spectral; type defined 
; (23-feb-00 aph) AXIS standard documentation 
;- 
 
Function bnl_load, NOF=nof, DEFPATH=DefPath 
 
; on_error,2 
fltr='*.asc' 
if keyword_set(nof) then fltr='*' 
file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath) 
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename 
	openr, iunit, file, /get_lun 
	tmp = '' 
	For i = 0,10 DO BEGIN 		; skip over header 
		readf, iunit, tmp 
;		print,tmp 
	ENDFOR 
	a = fltarr(2,512) 
	j = 0 
	while not eof(iunit) do begin 
           ;if j/100 eq j/100. then print,j 
           readf,iunit,tmp 
           cpos = strpos(tmp,',') 
           a(0,j) = float(strmid(tmp,0,cpos)) 
           a(1,j) = float( strmid(tmp,cpos+1,strlen(tmp))) 
           j=j+1 
    endwhile 
    close,iunit 
    free_lun,iunit 
	d = a(1, *) 
	x = a(0, *) 
	norm = 0*d + 1. 
	t = ax_name(file) 
	file = strlowcase(t(1)) 
	xl = 'Wavelength' 
	dl = file + ' NSLS ascii' 
	s = create_struct('t','1d','x',x,'d',d,'dn',norm,'xl',xl,'dl',dl) 
	np = n_elements(d) 
;	print, np, ' points . Data from: ', s.x(0),' to ',s.x(np-1) 
	print, 'Spectrum read from NSLS ASCII file: ', file 
endif else begin 				; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    s=0 
endelse 
return, s 
 
end