; Copyright (c) 1998-2017 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_XYSCL
;
;LAST CHANGED: ----------------------------------- 13 Mar 2017 (aph)
;
;PURPOSE:
;	This procedure sets the (x,y) scales of images
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	AX_XYSCL
;
;CALLED FROM AXIS:
;	Images->Set XY scale

;INPUTS: none
;
;KEYWORDS: none
;
;OUTPUTS: none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (xx-sep-97 aph) first wrote for Mephisto data
; (14-jun-98 aph) axis_com
; (08-jun-99 aph) add group keyword to get_num; fixed error !
; (01-jan-00 aph) AXIS standard documentation
; (19-nov-16 aph) remember last values and offer as default; change label to end
; (13-mar-17 aph) correct logic of using prior (xy)-calib info
;-

PRO ax_xyscl
@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
 if tmp.t EQ '2d' then begin         ; ONLY for images
;
; ----- use existing axis_com variables from XRF processing to store results
; mesh_x, mesh_y  - final converted image pixel counts
; xrf_cols_start, xrf_rows_start - data X-Y, values of 1st point derived from cursor to set range
; xrf_cols_stop, xrf_rows_stop   - data X-Y, values of 2nd points derived from cursor to set range
; xrf_energy - line length
	 if n_elements(xrf_cols_start) GT 0 then begin
	 	test = dialog_message('set X,y-scale with existing values (default = No)', $
	 	        /question,dialog_parent=aXis_ID, /default_no, title='use existing values?')
	 	if test EQ 'Yes' then begin
	 		x1 = xrf_cols_start & y1 = xrf_rows_start
	 		x2 = xrf_cols_stop  & y2 = xrf_rows_stop
	 		dist_new = xrf_energy
	 		goto, skip_select
	 	endif
	endif
; -------- ask user to use cursor to identify 2 fiducial points on the image to set length
; -------- these can be any 2 sets of (x,y) points
 	SetGraf, 'MainImg'
	WIDGET_CONTROL, Uprompt, SET_VALUE='Set XY scale: select 1st point'
	cursor, x1, y1, /data, /down
	CurInd = DIndex(x1(0),y1(0),tmp)
	CurX1 = CurInd(0) & CurY1 = CurInd(1)
	Xd1 = tmp.x(curx1) & Yd1 = tmp.y(cury1)
; print, '1st point: ', x1(0), y1(0), ' in tmp', xd1, yd1
	xrf_cols_start = x1(0)	; save for later use
	xrf_rows_start = y1(0)
	WIDGET_CONTROL, Uprompt, SET_VALUE='Set XY scale: select 2nd point'
	cursor, x2, y2, /data, /down
	CurInd = DIndex(x2(0),y2(0),tmp)
	CurX2 = CurInd(0) & CurY2 = CurInd(1)
	Xd2 = tmp.x(curx2) & Yd2 = tmp.y(cury2)
	xrf_cols_stop = x2(0)	; save for later use
	xrf_rows_stop = y2(0)
; print, '2nd point: ', x2(0), y2(0), ' in tmp', xd2, yd2
	dist_new = get_num(prompt='Distance (um)', group=axis_id)
	xrf_energy = dist_new
    skip_select:
	dist =sqrt((x2(0)- x1(0))*(x2(0)- x1(0)) + (y2(0) - y1(0))*(y2(0) - y1(0)) )
	slope = dist_new(0)/dist
; print, 'original, new, Slope = ', dist, dist_new(0), slope

	tmp.x = slope*(tmp.x - x1(0))
	tmp.y = slope*(tmp.y - y1(0))
	CurBuf = 0
	tmp.dl = tmp.dl + ' scl'
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	Label(CurBuf) = tmp.dl
	PlotBuf,CurBuf
	WIDGET_CONTROL, Uprompt, SET_VALUE='XY scale stretched by ' + string(slope)
endif else WIDGET_CONTROL, Uprompt, SET_VALUE='XY-scale: only for images'
END