; Copyright (c) 1998-2019 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_XYDIS
;
;LAST CHANGED: ----------------------------------- 11-Jun-19 (aph)
;
;PURPOSE:
;	This procedure modifies (x) and/or (y) pixel size based on
; user-defined ultiplicative factors (only the ratio of pixel sizes changes
; NB - use Images~Modify X,Y axes to change the x, or y scales independently
;    - use Images~Set X,Y scale to isomporhically set the x,y scale
;    - use Images~Calibrate to calibrate the x,y scale (1-point = shift; 2-point = shift, stretch)
;
;CATEGORY:
;	AXIS: image utility
;
;CALLING SEQUENCE:
;	AX_XYDIS
;
;CALLED FROM AXIS:
;	Images->Distort XY scale
;
;INPUTS: none
;
;KEYWORDS: none
;
;OUTPUTS:
;	modified image is written to buffer 0
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (fall-97 aph) - first wrote for Mephisto data
; (14-jun-98 aph) add axis_com
; (08-jun-99 aph) add group call to get_num
; (14-dec-99 aph) get correct (x,y) values
; (25-dec-99 aph) interpolate to square pixels
; (01-jan-00 aph) AXIS standard documentation
; (11-dec-11 aph) modify to work properly
;    (prior to 10-dec-11 this routine only worked if xfactor=1.0 and yfactor < 1.0)
; (11-Jun-19 aph)  track down why 2nd application of this routine gives unusable result
;             (crashes in ax_mesh  with "Array dimensions must be greater than 0." error) NOT RESOLVED
;-
PRO ax_xydis
@axis_com
on_error,2

;   ******************** Warp X versus Y pixel size  of image  *********
HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
  if tmp.t EQ '2d' then begin         ; ONLY for images

;	print, ' original image'
;		help, tmp, /struct

    xsz = n_elements(tmp.x)
	ysz = n_elements(tmp.y)
	if n_elements(dist_xy) EQ 0 then begin
		dist_xy = fltarr(2)		; defaults are set up for XMCD images with 30 deg sample rotation
 		dist_xy(0) = 1.155		; x-axis is stretched by 2/sqrt(3)
 		dist_xy(1) = 1.0
	endif
	dist_xy(0) = get_num(title = 'Distort image ',prompt='X-axis factor', val=dist_xy(0), group = axis_id)
	dist_xy(1) = get_num(title = 'Distort image ',prompt='Y-axis factor', val=dist_xy(1), group = axis_id)


; ---------  use expand to modify image -------
	nxsz = fix(dist_xy(0)*xsz)
	tx = congrid(tmp.x,nxsz)				; get right nimber of x axis points
	nysz = fix(dist_xy(1)*ysz)
	ty = congrid(tmp.y,nysz)				; get right nimber of y axis points
	expand,tmp.d, nxsz, nysz, td            ; expand image

; ------  what happens if only change AXES, but leave data array the same
;	tx = tmp.x*dist_xy(0)
;	ty = tmp.y*dist_xy(1)			;
;	td = tmp.d

; ------------- change (x,y) scale
	tx = tx*dist_xy(0)
	ty = ty*dist_xy(1)

; --------- re-assemble data structure
;	print, ' original image'
;	help, tmp, /struct

		tmp = create_struct('t','2d','x',tx,'y',ty,'d',td, 'e', tmp.e, $
		'xl',tmp.xl,'yl',tmp.yl,'dl',tmp.dl + ' xyF')

;	print, ' distorted image'
;	help, tmp, /struct
;	print, 'X-axis: ', min(tmp.x),' to ', max(tmp.x)

; ------- store distorted image in buffer 0
	CurBuf = 0
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	Label(CurBuf) = tmp.dl
	PlotBuf,CurBuf

	axis_log, 'Distort XY scale'
	axis_log, ' X-factor ' + string(dist_xy(0), format='(F4.2)')
	axis_log, ' Y-factor ' + string(dist_xy(1), format='(F4.2)')

  endif else axis_log, SET_VALUE='distort-XY: only for images'
ENDIF
END