 ; Copyright (c) 1998-2012 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_READ_XAS
;
;LAST CHANGED: ----------------------------------- 11-Aug-12
;
;PURPOSE:
;	This function reads in data from an ascii XAS format file (annotated spectral format)
; and places the result into an AXIS 1d structure.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	Result = ax_read_xas(file = file, nof = nof)
;
;CALLED FROM AXIS:
;	->Read->NSLS->XAS
;
;INPUTS:
;	INPUT - POSITIONAL INPUTS only (not keywords)
;	All input parameters are passed as keywords.
;
;KEYWORDS:
;	FILE = filename. If not supplied the user is prompted.
;   NOF = no filter (default is *.xas)
;
;OUTPUTS:
;	The result is placed in buffer 0.
;
; PROCEDURE:
;   Uses X1A routine READ_XAS.PRO to read data, then packages as an AXIS 1d structure.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks

;MODIFICATION HISTORY:
; (22-feb-00 aph) AXIS standard documentation
; (11-Aug-12 aph) add filename as the label
;-

FUNCTION ax_read_xas, file = file, nof = nof

@axis_com
on_error,2


if not keyword_set(file) then begin
	fltr='*.xas'
	if keyword_set(nof) then fltr='*'
	file = pickfile2(/read, FILTER=fltr, /LPATH, DefPath=DefPath) ;, get_path=WritePath)
endif

; -- read spectral data from XAS format file ---
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename
	read_xas,file, x, y, header
	t = ax_name(file)
	s = {t:'1d', x: x, d: y, dn: y, xl: 'E (eV)', dl: t(1) + ' ' + header.formula}
	print, 'XAS spectrum read from ', file
endif else s = 0

return, s

END