FUNCTION ax_file_protect, file, overwrite=overwrite

; ---------- last changed:  14-nov-00 (aph)
;
; DESCRIPTION
; This FUNCTION  checks for existence of the indicated file
; If the file exists it uses a dialog box to allow user to confirm or to change the file name
; The user-requested filename is returned as the same paramater in the function call

;
; INPUT
;	FILE =	name of file (including path) to check for possible overwrite
;
; KEYWORDS
;	OVERWRITE	parameter to indicate permission status on overwriting
;			= 0 - DO NOT overwrite
;			= 1 - OK to overwrite
; NB I retain this parameter in cases where I need to write multiple files so the
; user can decide once for overwriting all files of a certain type
; the file_overwrite is a pop-up widget to ask the user this question
; - it is klugey but it works
;
; HISTORY
; (14-nov-00 aph) first wrote

test = findfile(file)
if test(0) EQ file then begin
    tn = ax_name(file)
    nfilter = tn(2)
	if keyword_set(overwrite) then begin
		if overwrite NE 1 then begin
		    if WIDGET_INFO(/active) then t = file_overwrite(group = axis_ID, val = 1) $
		        else t = file_overwrite(val = 1)
		    if t EQ 0 then file = dialog_pickfile(/write, $
		         FILE = file, filter=nfilter, title='FILE EXISTS! Confirm or change name')
		    if t EQ 2 then overwrite = 1
		endif
	endif else file = dialog_pickfile(/write, FILE = file, filter=nfilter)
endif
END




