; $Id: str_columns.pro,v 1.1 1997/12/16 02:06:30 loo Exp $ 
; 
;+ 
; NAME: 
;       STR_COLUMNS 
; 
; PURPOSE: 
;       This procedure takes a string array containing rows of text, and 
;       divides it into a 2-D array with each row divided into columns. 
; 
; CATEGORY: 
;       String processing. 
; 
; CALLING SEQUENCE: 
;       STR_COLUMNS, Input 
; 
; INPUTS: 
;       Input:     A 1-D string array. Each element is a row of text containing 
;                  columns of text separated by a delimiter. Each row must  
;                  have the same number of column elements. The input array 
;                  will be overwritten by the resulting 2-D string array. 
; 
; KEYWORD PARAMETERS: 
;       DELIMITER: A string containing the delimiter between columns. The  
;                  default delimiter is white space between columns. See 
;                  the documentation for SPLIT_STRING for details. 
; 
; OUTPUTS: 
;       The input parameter is overwritten with the output. 
; 
; ROUTINES USED BY THIS MODULE: 
;       SPLIT_STRING             (Bill Loo's IDL routine) 
; 
; WRITTEN BY: 
;       Billy W. Loo, Jr. 
;       Bioengineering Graduate Group, UCSF / UCB 
;       School of Medicine, UCD 
;       Lawrence Berkeley National Lab 
;       December, 1997 
;- 
; 
; MODIFICATION HISTORY: 
; 
; $Log: str_columns.pro,v $ 
; Revision 1.1  1997/12/16 02:06:30  loo 
; Initial revision 
; 
 
PRO STR_COLUMNS, input, _EXTRA=extra 
  ;Make sure input is string array. 
  in_sz = SIZE(input) 
  in_tp = in_sz[in_sz[0]+1] 
   
  IF (in_tp NE 7) THEN MESSAGE, 'Input type must be string.' + STRING(7B) 
   
  ;Split first row to find number of columns. 
  row0 = SPLIT_STRING(input[0], _EXTRA=extra) 
  ncols = N_ELEMENTS(row0) 
   
  ;Initialize result. 
  result = STRARR(ncols, N_ELEMENTS(input)) 
   
  result[*, 0] = TEMPORARY(row0) 
   
  ;Fill in rows of result. 
  FOR i = 1, N_ELEMENTS(input)-1 DO BEGIN 
    result[*, i] = SPLIT_STRING(input[i], _EXTRA=extra) 
  ENDFOR 
   
  ;Replace input with result 
  input = TEMPORARY(result) 
   
  RETURN 
END ;str_columns