; Copyright (c) 1998-2009 A.P. Hitchcock   All rights reserved
;+
;NAME:
;	ISNUMBER.PRO
;
;LAST CHANGED: ----------------------------------- 11-Aug-09
;
;PURPOSE:
;	This  function checks if a string is numerical

;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = ISNUMBER(string)
;
;CALLED FROM AXIS:
;	many procedures
;
;ROUTINES
;	ISNUMBER	returns 1 if string is numerical; 0 i not

;COMMON BLOCKS: none
;
;-----------------
; FILE ROUTINES -- eli's text format
;-----------------
;file structure-
;line 0: number of items
;line 1: string=name of first item
;line 2: size(item)
;line 3: item, space-delimited
;line 4: string=name of next item
;
;MODIFICATION HISTORY:
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in
; (26-feb-00 aph) AXIS standard documentation
; (11-Aug-09 aph) isolate from file.pro (each routine has its own name)
;-
;
function isNumber, string
  ;returns 1 if string is a number else  0
  on_Error,2
  error=0
  for i=0, strlen(string)-1 do begin
    ch=strmid(string, i, 1)
    if ((ch ge '0') and (ch le '9')) or (ch eq 'e') or (ch eq 'E') $
       or (ch eq '+') or (ch eq '-') or (ch eq '.') or (ch eq string(13B)) then $
         error=error else error=error+1
  endfor
  return,(error eq 0)
end