; Copyright (c) 1998-2018 A.P. Hitchcock  All rights reserved
;+
;NAME: AX_CHECK_OVERWRITE
;
;
;LAST CHANGED: ----------------------------------- 	08 April 2018

; PURPOSE:
;	This function checks if a TESTNAME = (path&filename&extension) exists
; If it does, the user is asked if they wish to overwrite or change the name

; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
; for functions
;   RESULT = AX_CHECK_OVERWRITE(FILENAME)
;
; INPUTS:
;	FILENAME	filename.
;
; KEYWORDS:
;	EXT:  extension
;
; OUTPUTS: returns name of revised file if provided
;
; COMMON BLOCKS:
; AXIS.COM    standard set of common blocks
;
; MODIFICATION HISTORY:
; (08-Apr-18 aph) first version
;-

FUNCTION AX_CHECK_OVERWRITE, testname, ext=ext
@axis_com

file = testname
t = ax_name(file)
; check if path is included; if not, ask user to define filename
if strlen(t(0)) EQ 0 then begin
   file = pickfile2(title='navigate to folder of interest & select or type filename')
endif

test1 = findfile(file)
if test1(0) NE file then return, file

t=ax_name(file)
IF keyword_Set(ext) then exten = ext else exten = t(2)

if widget_info(/active) EQ 1 then $
   t = file_overwrite(group = axis_ID, val = 1) else t = file_overwrite(val = 1)
;  print, 'code from overwrite ', t
if t EQ 0 then file = pickfile2(/write, fltr=exten, $
                    LFILE = file, title = 'Alternate filename', DefPath=DefPath)

t = ax_name(file)
file = t(0) + t(1) + '.' + exten  ; force extension to that given by input file


return, file
end
