; Copyright (c) 1998-2019 A.P. Hitchcock  All rights reserved
;+
;NAME:  READ_COARSE_GONI_SCAN
;
;
;LAST CHANGED: ----------------------------------- 	05 Jul 2019

; PURPOSE:
;	This procedure uses h5_parse to read COARSE_GONI_SCAN data files written by pySTXM (starting June 2019)
; Temporary while the format is not finalized
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;   RESULT = READ_COARSE_GONI_SCAN(file)
;
; INPUTS:
;	FILE	filename.
;
; OUTPUTS:
;	axis binary image (*.axb) returned if successfully read. Otherwise a blank string
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (05-July-19 aph) first version
;-


function read_coarse_goni_scan, file
@axis_com
on_Error,2

tmp = ''
hdf5_in = h5_parse(file, /read_data)
if n_tags(hdf5_in) GT 0 then begin
	d = hdf5_in.entry0.counter0.data._data
	x = hdf5_in.entry0.counter0.sample_x._data
	y = hdf5_in.entry0.counter0.sample_y._data
	e = hdf5_in.entry0.counter0.energy._data
	dwell = 1000.*hdf5_in.entry0.counter0.count_time._data
	stxm_scan_type = hdf5_in.entry0.counter0.stxm_scan_type._name
	channel_name = hdf5_in.entry0.counter0._name
	t = ax_name(file)
	dl = t(1) + '    ' + channel_name
	xl =  string(e(0), dwell, format= $
	  '("x(um)    E =",f7.2," eV.   Dwell =",f5.2," ms.")')
	yl = stxm_scan_type + '    y (um)'

	tmp= {t:'2d', x: x, y:y ,d:d, e:e(0), xl:xl(0), yl:yl, dl:dl}

;	help, tmp, /struct
endif
return, tmp
END