; Copyright (c) 1998-2025 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	STXM_MOVIE_BATCH_TEST.PRO
;
;
;LAST CHANGED: ----------------------------------- 	04-Dec-2025 (aph)

; PURPOSE:
;	This procedure is used to test multi-step batch processing
;
; CATEGORY:
;	    Runs stand alone using @STXM_MOVIE_BATCH_TEST   (see IDL help on how to run batch files)
;   OR  can put code into ax_macro.pro and run from aXis2000  using Utilities~Execute_macro

; CALLING SEQUENCE:
; for procedures:
;	PRO_NAME = PRO_NAME, parameters
;
; for functions
;   RESULT = FUNCTION_NAME(parameters)
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS:
;
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
 ; (18-Feb+23) first version
 ; (04_Dec_25 aph) explore


;-


STXM_MOVIE_BATCH_TEST.PRO

files = strarr(2)
;files(0) = "Y:\data\XRM\stxm_Bessy\Maxymus\2023\23-02\02-05\MPI_230205101\MPI_230205101.hdr"
; files(1) = "Y:\data\XRM\stxm_Bessy\Maxymus\2023\23-02\02-05\MPI_230205102\MPI_230205102.hdr"

files(0) = 'D:\aXis-Pass-Test-data\09-UTILITIES\05-EXECUTE MACRO\MPI_230205101\MPI_230205101.hdr'
files(1) = 'D:\aXis-Pass-Test-data\09-UTILITIES\05-EXECUTE MACRO\MPI_230205102\MPI_230205102.hdr'

for i = 0, n_elements(files)-1 do begin & $
	stack = files(i)  & $
	a=read_sdf(stack, channel=1, /auto_save,  /silent)  & $
;	ax_convert_to_odc, stack=a, roi_io=roi_io, ecal=0.85  & $
endfor	 & $
stop