;+
; PRO LineClear
; ------------------------ last changed: 08-Oct-21
;
; clears lines from AXIS main image window
; as a function of where in the sequence of key clicks one is
;
; REVISION HISTORY
; (???? aph) in aaa_axis  until 12-aug-99
; (08-oct-21 aph) adapt for vertical lines
;
PRO LineClear

@axis_com

; reset line-out information system on MainImg
  	HANDLE_VALUE, Data(CurBuf), tmp
	IF n_tags(tmp) NE 0 THEN BEGIN
		SetGraf, 'MainImg'
		WIDGET_CONTROL,delX,SET_VALUE=''     ; erase old del(xyz)val
	    WIDGET_CONTROL,delY,SET_VALUE=''
	    WIDGET_CONTROL,delR,SET_VALUE=''
	  	WIDGET_CONTROL,delZ,SET_VALUE=''
		line2d_thick=0 & line1d1_thick=0  & line1d2_thick=0
	  	clktmp = STRCOMPRESS(string(click1))
		CASE clktmp OF
		  '0': BEGIN
				line2d_thick=0
				line1d1_thick=0
				line1d2_thick=0
			END
		  '1': BEGIN
				line2d_thick=1
				line1d1_thick=1
				line1d2_thick=0
			END
		  '2': BEGIN
				line2d_thick=2
				line1d1_thick=1
				line1d2_thick=1
			END
			ELSE:
		ENDCASE
		if clktmp NE '0' then begin
		    CASE tmp.t OF
			  '2d': BEGIN
				   	device, get_graphics = oldgraph, set_graphics = 6      ;Set xor - erase line
		       		plots, xline, yline,/data, thick=line2d_thick
		       		device, set_graphics = oldgraph   ; reset graphics mode
				END
			   '1d': BEGIN
				  ; erase reference lines on spectrum
		   		   	device, get_graphics = oldgraph, set_graphics = 6      ;Set xor
					plots, [xline(0),xline(0)], yRng,/data, thick=line1d1_thick
		       		plots, [xline(1),xline(1)], yRng,/data, thick=line1d2_thick
		       		device, set_graphics = oldgraph   ; reset graphics mode
				END
				ELSE:
	    	ENDCASE
 	    endif
 	    click1 = 0    ; restart sequence
    ENDIF
END
