; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_RGB_WIDGET
;
;LAST CHANGED: ----------------------------------- 	20-apr-08
;
; PURPOSE:
;	This set of procedures is a widget which generates R_G-B
; composite maps with full control on source, limits etc
; uses CW_slider - a complex slider with 2-levels of control taken from web (Thomas D�ring, June 2007)
;
; CATEGORY:
;	Image display - captive to aXis2000
;
; CALLING SEQUENCE:
; for procedures:
;	AX_RGB_WIDGET
;
; INPUTS: default set of buffers are R=4, G=5, B=6 if not previously selected
;
; KEYWORDS: none
;
; OUTPUTS:
;		RGB image saved as a tif file
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	AX_RGB_COM  common block  for AX_RGB_WIDGET
;
; SIDE EFFECTS:
;	A window is created/destroyed.
;
; RESTRICTIONS:
;
; MODIFICATION HISTORY:
; (10-Mar-06 aph) widget structure first generated
; (26-Dec-07 aph) coded
; (20-apr-08 aph) clean up description
;-

FUNCTION num_format, value
num_string = strtrim(string(value,format = '(g9.2)'))
return, num_string
END

PRO MakeRGB
@axis_com
@ax_rgb_com
on_error,2

;  ************ Generate an RBG composite from 3 images (do not use buffer 0) *******
; ------- select all data from images within slider ranges
R_exist = 0 & G_exist = 0 & B_exist = 0
 Rimg_size=[0,0] &  Gimg_size=[0,0] &  Bimg_size=[0,0]
if red_index GT 0 AND red_index LE 9 then begin
	HANDLE_VALUE, Data(red_index), tmpR
	IF n_tags(tmpR) EQ 0 THEN RETURN
		IF tmpR.t EQ '2d' THEN BEGIN
		ri=tmpR.d
		tmp_index = where(ri LT r_min, count)
		if count GT 0 then ri(tmp_index)=r_min
		tmp_index = where(ri GT r_max, count)
		if count GT 0 then ri(tmp_index)=r_max
		Rimg_size=[n_elements(tmpR.x), n_elements(tmpR.y)]
		R_exist = 1
	ENDIF
endif
if green_index GT 0 AND green_index LE 9 then begin
	HANDLE_VALUE, Data(green_index), tmpG
	IF n_tags(tmpG) EQ 0 THEN RETURN
	IF tmpG.t EQ '2d' THEN BEGIN
		gi=tmpG.d
		tmp_index = where(gi LT g_min, count)
		if count GT 0 then gi(tmp_index)=g_min
		tmp_index = where(gi GT g_max, count)
		if count GT 0 then gi(tmp_index)=g_max
		Gimg_size=[n_elements(tmpG.x), n_elements(tmpG.y)]
		G_exist = 1
	ENDIF
endif
if blue_index GT 0 AND blue_index LE 9 then begin
	HANDLE_VALUE, Data(blue_index), tmpB
	IF n_tags(tmpB) EQ 0 THEN RETURN
	IF tmpB.t EQ '2d' THEN BEGIN
		bi=tmpB.d
		tmp_index = where(bi LT b_min, count)
		if count GT 0 then bi(tmp_index)=b_min
		tmp_index = where(bi GT b_max, count)
		if count GT 0 then bi(tmp_index)=b_max
		Bimg_size=[n_elements(tmpB.x), n_elements(tmpB.y)]
		B_exist = 1
	ENDIF
endif

IF R_exist OR  G_exist OR B_exist THEN BEGIN
	x_size = max([Rimg_size(0),Gimg_size(0),Bimg_size(0)])
	y_size = max([Rimg_size(1),Gimg_size(1),Bimg_size(1)])
	img_size=[x_size, y_size]
	image = bytarr(3,img_size(0), img_size(1))
; ---- deal with cases where R, G, B might be missing ---------
	if n_elements(ri) EQ 0 then begin
		ri=fltarr(img_size)
		r_min= 0. & r_max = 0.
	endif
	if n_elements(gi) EQ 0 then begin
		gi=fltarr(img_size)
		g_min= 0. & g_max = 0.
	endif
	if n_elements(bi) EQ 0 then begin
		bi=fltarr(img_size)
		b_min= 0. & b_max = 0.
	endif

	if r_max NE r_min then rslope = 255./(r_max-r_min) else rslope = 1.
	if g_max NE g_min then gslope = 255./(g_max-g_min) else gslope = 1.
	if b_max NE b_min then bslope = 255./(b_max-b_min) else bslope = 1.
	R_image(0,*,*) = byte(rslope*(ri-r_min))
	G_image(1,*,*) = byte(gslope*(gi-g_min))
	B_image(2,*,*) = byte(bslope*(bi-b_min))

;	image = bytarr(img_size(0), img_size(1))
;	rgball=[ri,gi,bi]
;	all_min = min(rgball,max=all_max)
;	slope = 255./(all_max-all_min)
;	image = byte(slope*(ri + gi + bi-3*all_min))

	wset, RGB_display
; ------ set up color scale (use default if it is not already set)
	if n_elements(ax_top_color_index) EQ 0 then ax_top_color_index = 256
	r = indgen(ax_top_color_index) & g = indgen(ax_top_color_index) & b = indgen(ax_top_color_index) ; make linear color tables for R G B
	main = 360*gr_scale
 	t_scl = main/max([img_size(0), img_size(1)])
 	nx = fix(t_scl*img_size(0))
 	ny = fix(t_scl*img_size(1))
 	t_image = intarr(3, nx, ny)
 	for i=0,2 do $
 		t_image(i,*,*) = congrid(reform(rgb_image(i,*,*)),nx, ny, /interp)
 	tvlct, r,g,b
 ;print, 'Min & max of display ', min(t_image), max(t_image)
 	tv, t_image, /true

ENDIF  ELSE axis_log, 'One or more of selected buffers is not an image'
END

;-----------------------------------------------------------------
pro TEXT_RGB_RMAX, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmax')
WIDGET_CONTROL,id, Get_value = r_max
print, 'Rmax changed to ', r_max
WIDGET_CONTROL,id, Set_value = num_format(r_max)
makeRGB
end

;-----------------------------------------------------------------
pro TEXT_RGB_Gmax, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Gmax')
WIDGET_CONTROL,id, Get_value = g_max
WIDGET_CONTROL,id, Set_value = num_format(g_max)
makeRGB
end

;-----------------------------------------------------------------
pro TEXT_RGB_Bmax, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Bmax')
WIDGET_CONTROL,id, Get_value = b_max
WIDGET_CONTROL,id, Set_value = num_format(b_max)
makeRGB
end
;-----------------------------------------------------------------
pro TEXT_RGB_Rmin, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmin')
WIDGET_CONTROL,id, Get_value = r_min
WIDGET_CONTROL,id, Set_value = num_format(r_min)
print, 'Rmin changed to ', r_min
makeRGB
end

;-----------------------------------------------------------------
pro TEXT_RGB_Gmin, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Gmin')
WIDGET_CONTROL,id, Get_value = g_min
WIDGET_CONTROL,id, Set_value = num_format(g_min)
makeRGB
end

;-----------------------------------------------------------------
pro TEXT_RGB_Bmin, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Bmin')
WIDGET_CONTROL,id, Get_value = b_min
WIDGET_CONTROL,id, Set_value = num_format(b_min)
makeRGB
end
; ---------------------------------------------------
pro LIST_RGB_RED, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_red')
red_index = WIDGET_INFO(id, /Droplist_select)
HANDLE_VALUE, Data(red_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then begin
		rgb_label(red_index) = label(red_index)
		r_min = min(tmp.d, max=r_max)
	endif else begin
		rgb_label(red_index)= 'not an image'
		r_min = 0 & r_max = 0
	endelse
ENDIF ELSE BEGIN
	if red_index NE 0 then rgb_label(red_index)= 'empty' else rgb_label(red_index)= 'none'
	r_min = 0. & r_max = 0
ENDELSE
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmin')
WIDGET_CONTROL,id, Set_value = num_format(r_min)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmax')
WIDGET_CONTROL,id, Set_value = num_format(r_max)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_red')
widget_control, id, set_value = rgb_label, SET_DROPLIST_SELECT = red_index
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Index_Red')
widget_control, id, set_value = strtrim(string(red_index),2)
;print, 'Red color set to: ', rgb_label(red_index)
makeRGB
end

pro LIST_RGB_GREEN, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_green')
green_index = WIDGET_INFO(id, /Droplist_select)
HANDLE_VALUE, Data(green_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then begin
		rgb_label(green_index) = label(green_index)
		g_min = min(tmp.d, max=g_max)
	endif else begin
		rgb_label(green_index)= 'not an image'
		g_min = 0 & g_max = 0
	endelse
ENDIF ELSE BEGIN
	if green_index NE 0 then rgb_label(green_index)= 'empty' else rgb_label(green_index)= 'none'
	g_min = 0 & g_max = 0
ENDELSE
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Gmin')
WIDGET_CONTROL,id, Set_value = num_format(g_min)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Gmax')
WIDGET_CONTROL,id, Set_value =  num_format(g_max)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_green')
widget_control, id, set_value = rgb_label, SET_DROPLIST_SELECT = green_index
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Index_Ggreen')
widget_control, id, set_value = strtrim(string(green_index),2)
; print, 'Green color set to: ', rgb_label(green_index)
makeRGB
end

pro LIST_RGB_BLUE, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_blue')
blue_index = WIDGET_INFO(id, /Droplist_select)
blue_label = rgb_label(blue_index)
HANDLE_VALUE, Data(blue_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then begin
		rgb_label(blue_index) = label(blue_index)
		b_min = min(tmp.d, max=b_max)
	endif else begin
		rgb_label(blue_index)= 'not an image'
		b_min = 0 & b_max = 0
	endelse
ENDIF ELSE BEGIN
	if blue_index NE 0 then rgb_label(blue_index)= 'empty' else rgb_label(blue_index)= 'none'
	b_min = 0 & b_max = 0
ENDELSE
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Bmin')
WIDGET_CONTROL,id, Set_value =num_format(b_min)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Bmax')
WIDGET_CONTROL,id, Set_value = num_format(b_max)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_blue')
widget_control, id, set_value = rgb_label, SET_DROPLIST_SELECT = blue_index
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Index_Blue')
widget_control, id, set_value = strtrim(string(blue_index),2)
; print, 'Blue color set to: ', rgb_label(blue_index)
makeRGB
end

;-----------------------------------------------------------------
pro TEXT_RGB_Index_Red, Event
@axis_com
@ax_rgb_com
on_error,2
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Index_Red')
widget_control, id, get_value = red_index
print, 'change red index to ', red_index
HANDLE_VALUE, Data(red_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then begin
		rgb_label(red_index) = label(red_index)
		r_min = min(tmp.d, max=r_max)
	endif else begin
		rgb_label(red_index)= 'not an image'
		r_min = 0 & r_max = 0
	endelse
ENDIF ELSE BEGIN
	if red_index NE 0 then rgb_label(red_index)= 'empty' else rgb_label(red_index)= 'none'
	r_min = 0. & r_max = 0
ENDELSE
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_DROPLIST_red')
widget_control, id, set_value = rgb_label, SET_DROPLIST_SELECT=red_index
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmin')
WIDGET_CONTROL,id, Set_value = num_format(r_min)
id = widget_info(Event.top, FIND_BY_UNAME = 'RGB_TEXT_Rmax')
WIDGET_CONTROL,id, Set_value = num_format(r_max)
end

;-----------------------------------------------------------------
pro TEXT_RGB_Index_Green, Event
@axis_com
@ax_rgb_com
on_error,2

print, ' Green index change routine not written'
end

;-----------------------------------------------------------------
pro TEXT_RGB_Index_Blue, Event
@axis_com
@ax_rgb_com
on_error,2

print, ' Blue index change routine not written'
end

;-----------------------------------------------------------------
pro BUT_RGB_SAVE, Event
@axis_com
@ax_rgb_com
on_error,2

print, ' SAVE routine not written'
end

;-----------------------------------------------------------------
pro  WIDGET_KILL_REQUEST, Event
@axis_com
@ax_rgb_com
on_error,2
WIDGET_CONTROL, Event.Top, /DESTROY
end

;-----------------------------------------------------------------
pro BUT_RGB_CANCEL, Event
@axis_com
@ax_rgb_com
on_error,2
WIDGET_CONTROL, Event.Top, /DESTROY
end

; **************************************************************************
; ---------------------------------  PROCESS CLICKS etc -------------------
pro RBG_BASE_event, Event
@axis_com
@ax_rgb_com
on_error,2

wWidget =  Event.top

  case Event.id of

; --------- kill ax_rgb_widget if use X in upper right corner --------------
    Widget_Info(wWidget, FIND_BY_UNAME='RBG_BASE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_KILL_REQUEST' )then $
       WIDGET_KILL_REQUEST, Event
    end

 ; ------------ select buffer  --------------
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_DROPLIST_red'): begin
    if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        LIST_RGB_RED, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_DROPLIST_green'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        LIST_RGB_GREEN, Event
    end
     Widget_Info(wWidget, FIND_BY_UNAME='RGB_DROPLIST_blue'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        LIST_RGB_BLUE, Event
    end

; -------------- adjust maxima and minima with slider
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Gmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_GMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Rmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_RMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Bmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_BMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Bmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_BMIN, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Rmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_RMIN, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_SLIDER_Gmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_SLIDER' )then $
        SLIDER_RGB_GMIN, Event
    end

; ------ adjust minima & maxima numerically
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Rmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_RMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Gmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_GMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Bmax'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_BMAX, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Rmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_RMIN, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Gmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_GMIN, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Bmin'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_BMIN, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Index_Red'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_Index_Red, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Index_Green'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_Index_Green, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_TEXT_Index_Blue'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_RGB_Index_Blue, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='RGB_BUTTON_circle'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_RGB_CIRCLE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='RGB_BUTTON_scales'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_RGB_CIRCLE, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='RGB_BUTTON_cancel'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_RGB_CANCEL, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='RGB_BUTTON_save'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_RGB_SAVE, Event
    end
    else:
  endcase

end


pro ax_rgb_widget, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@ax_rgb_com
on_error,2

tx = size(wGroup)
IF tx(1) EQ 0 THEN modal_val=0 else modal_val=1

  RBG_BASE = Widget_Base( GROUP_LEADER=wGroup, UNAME='RBG_BASE',  $
      modal = modal_val, TITLE='RGB composite map', $
     /TLB_KILL_REQUEST_EVENTS, SPACE=3 ,XPAD=3 ,YPAD=3)
  main = fix(360*gr_scale)
  RGB_image = Widget_Draw(RBG_BASE, UNAME='RGB_image' ,XOFFSET=240  $
      ,SCR_XSIZE=main ,SCR_YSIZE=main)

  tlabel = widget_label(RBG_BASE, XOFFSET=19 ,YOFFSET=9,value='Red')
  tlabel = widget_label(RBG_BASE, XOFFSET=108 ,YOFFSET=9,value='Green')
  tlabel = widget_label(RBG_BASE, XOFFSET=188 ,YOFFSET=9,value='Blue')

  RGB_SLIDER_Rmax = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Rmax'  $
      ,XOFFSET=25 ,YOFFSET=50 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)
  RGB_SLIDER_Gmax = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Gmax'  $
      ,XOFFSET=118 ,YOFFSET=50 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)
  RGB_SLIDER_Bmax = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Bmax'  $
      ,XOFFSET=198 ,YOFFSET=50 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)

  RGB_SLIDER_Rmin = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Rmin'  $
      ,XOFFSET=25 ,YOFFSET=135 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)
  RGB_SLIDER_Gmin = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Gmin'  $
      ,XOFFSET=118 ,YOFFSET=135 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)
  RGB_SLIDER_Bmin = Widget_Slider(RBG_BASE, UNAME='RGB_SLIDER_Bmin'  $
      ,XOFFSET=198 ,YOFFSET=135 ,SCR_XSIZE=18 ,SCR_YSIZE=75  $
      ,/SUPPRESS_VALUE ,/VERTICAL)

number_size = 8
  RGB_TEXT_Rmax = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Rmax'  $
      ,XOFFSET=13 ,YOFFSET=27 ,/EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)
  RGB_TEXT_Gmax = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Gmax'  $
      ,XOFFSET=91 ,YOFFSET=27 ,/EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)
  RGB_TEXT_Bmax = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Bmax'  $
      ,XOFFSET=169 ,YOFFSET=27 ,/EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)

  RGB_TEXT_Rmin = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Rmin'  $
      ,XOFFSET=13 ,YOFFSET=212, /EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)
  RGB_TEXT_Gmin = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Gmin'  $
      ,XOFFSET=91 ,YOFFSET=212 , /EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)
  RGB_TEXT_Bmin = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Bmin'  $
      ,XOFFSET=169 ,YOFFSET=212 ,/EDITABLE,/ALL_EVENTS ,XSIZE=number_size ,YSIZE=1)

  yoffset_red = main + 7
  yoffset_green = main + 33
  yoffset_blue = main + 60
  xoffset_lists = 190
  label_size = 60
  Index_size = label_size + 30
  tlabel = widget_label(RBG_BASE, XOFFSET=xoffset_lists ,YOFFSET= yoffset_red,value='Red')
  tlabel = widget_label(RBG_BASE, XOFFSET=xoffset_lists ,YOFFSET=yoffset_green,value='Green')
  tlabel = widget_label(RBG_BASE, XOFFSET=xoffset_lists ,YOFFSET=yoffset_blue,value='Blue')
  RGB_TEXT_INDEX_Red = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Index_Red', sensitive = 1  $
      ,XOFFSET= xoffset_lists + label_size,YOFFSET=yoffset_red, /EDITABLE,/ALL_EVENTS ,XSIZE=1 ,YSIZE=1)
  RGB_TEXT_INDEX_Green = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Index_Green', sensitive = 1  $
      ,XOFFSET= xoffset_lists + label_size,YOFFSET=yoffset_green, /EDITABLE,/ALL_EVENTS ,XSIZE=1 ,YSIZE=1)
  RGB_TEXT_INDEX_Blue = Widget_Text(RBG_BASE, UNAME='RGB_TEXT_Index_Blue', sensitive = 1  $
      ,XOFFSET= xoffset_lists + label_size,YOFFSET=yoffset_blue, /EDITABLE,/ALL_EVENTS ,XSIZE=1 ,YSIZE=1)

  RGB_DROPLIST_red = Widget_Droplist(RBG_BASE,  $
      UNAME='RGB_DROPLIST_red' ,XOFFSET= xoffset_lists + index_size ,YOFFSET = yoffset_red  $
      ,SCR_XSIZE=240  ,SCR_YSIZE=26)
  RGB_DROPLIST_green = Widget_Droplist(RBG_BASE,  $
      UNAME='RGB_DROPLIST_green' ,XOFFSET=xoffset_lists + index_size ,YOFFSET =  yoffset_green  $
      ,SCR_XSIZE=240 ,SCR_YSIZE=26)
  RGB_DROPLIST_blue = Widget_Droplist(RBG_BASE,  $
      UNAME='RGB_DROPLIST_blue' ,XOFFSET=xoffset_lists + index_size ,YOFFSET = yoffset_blue  $
      ,SCR_XSIZE=240,SCR_YSIZE=26)

  RGB_BUTTON_circle = Widget_Button(RBG_BASE, /checked_menu,  $
      UNAME='RGB_BUTTON_circle' ,XOFFSET=14 ,YOFFSET=280 ,/ALIGN_LEFT  $
      ,VALUE='color circle ')
  RGB_BUTTON_scales = Widget_Button(RBG_BASE, /checked_menu,  $
     UNAME='RGB_BUTTON_scales' ,XOFFSET=120 ,YOFFSET=280 ,/ALIGN_LEFT ,VALUE='scales')

  RGB_BUTTON_cancel = Widget_Button(RBG_BASE,  $
      UNAME='RGB_BUTTON_cancel' ,XOFFSET=26 ,YOFFSET=330  $
      ,SCR_XSIZE=114 ,SCR_YSIZE=46 ,/ALIGN_CENTER ,VALUE='Cancel')
  RGB_BUTTON_save = Widget_Button(RBG_BASE, UNAME='RGB_BUTTON_save'  $
      ,XOFFSET=27 ,YOFFSET=390 ,SCR_XSIZE=114 ,SCR_YSIZE=46  $
      ,/ALIGN_CENTER ,VALUE='Save')

; populate the Widget parameters

; -------- list of image files
rgb_label = strarr(10)
rgb_label(0) = 'none'
FOR I = 1,9 DO BEGIN
	HANDLE_VALUE, Data(i), tmp
	IF n_tags(tmp) NE 0 THEN BEGIN
		if tmp.t EQ '2d' then rgb_label(i) = label(i) else rgb_label(i)= 'not an image'
	ENDIF ELSE rgb_label(i)= 'empty'
ENDFOR
red_index   = 4
green_index = 5
blue_index  = 6
widget_control, RGB_TEXT_INDEX_Red, set_value = strtrim(string(red_index),2)
widget_control, RGB_DROPLIST_red, set_value = rgb_label, SET_DROPLIST_SELECT = red_index
widget_control, RGB_TEXT_INDEX_Green, set_value = strtrim(string(green_index),2)
widget_control, RGB_DROPLIST_green, set_value = rgb_label, SET_DROPLIST_SELECT = green_index
widget_control, RGB_TEXT_INDEX_Blue, set_value = strtrim(string(blue_index),2)
widget_control, RGB_DROPLIST_blue, set_value = rgb_label, SET_DROPLIST_SELECT = blue_index

; -------- set initial values of min/max
r_min = 0 & r_max = 0
g_min = 0 & g_max = 0
b_min = 0 & b_max = 0

HANDLE_VALUE, Data(red_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then r_min=min(tmp.d,max=r_max)
ENDIF
HANDLE_VALUE, Data(green_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then g_min=min(tmp.d,max=g_max)
ENDIF
HANDLE_VALUE, Data(blue_index), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
	if tmp.t EQ '2d' then b_min=min(tmp.d,max=b_max)
ENDIF


widget_control, RGB_TEXT_Rmin, set_value=num_format(r_min)
widget_control, RGB_TEXT_Rmax, set_value=num_format(r_max)
widget_control, RGB_TEXT_Gmin, set_value=num_format(g_min)
widget_control, RGB_TEXT_Gmax, set_value=num_format(g_max)
widget_control, RGB_TEXT_Bmin, set_value=num_format(b_min)
widget_control, RGB_TEXT_Bmax, set_value=num_format(b_max)

; --------- realize and load the widget --------
Widget_Control, /REALIZE, RBG_BASE
; ---- get index of the draw window
WIDGET_CONTROL, RGB_image, GET_VALUE = RGB_display

; generate first RGB image (if there are 3 valid images)
MakeRGB

XManager, 'RBG_BASE', RBG_BASE

end

