; Copyright (c) 1998-20250 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_RGB
;
;LAST CHANGED: ----------------------------------- 04 Apr 2025 (aph)
;
; PURPOSE:
;	This procedure allows user to select 3 images from existing buffers
; and generates an RGB composite image, with optional storage.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	AX_RGB [, NO_SAVE=NO_SAVE]
;
;CALLED FROM AXIS:
;	->Utilities->RGB composite

;INPUTS: none
;
;KEYWORDS:
;	NO_SAVE  - do not ask for file name
;
;OUTPUTS: RGB image in MainImg and (optional) tif file on disk
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (18-sep-05 aph) first written; generated from images~RGB composite in axis_c
; (18-Mar-13 aph) add scale bar
; (24-Apr-13 aph)  remove scale_bar - inaccurate
; (19-Aug-20 aph) allow 1 or 2 color RGB if user selects an empty or spectral buffer
; (04-Apr-25 aph) change to Relative / Absolute
;-

PRO ax_RGB, NO_SAVE=NO_SAVE, scalebar=scalebar
@axis_com
on_error,2

;  ************ Generate an RBG composite from 3 images *******
BufR = buffer(group = AXIS_ID, Prompt='select RED image')
HANDLE_VALUE, Data(BufR), tmpR


BufG = buffer(group = AXIS_ID, Prompt='select GREEN image')
HANDLE_VALUE, Data(BufG), tmpG
BufB = buffer(group = AXIS_ID, Prompt='select BLUE image')
HANDLE_VALUE, Data(BufB), tmpB

;  ------ replace data sets that are not images with black images
IF n_tags(tmpR) NE 0  THEN BEGIN
	if tmpR.t EQ '2d' then tmpM=tmpR
ENDIF
IF n_tags(tmpG) NE 0  THEN BEGIN
	if tmpG.t EQ '2d' then tmpM=tmpG
ENDIF
IF n_tags(tmpB) NE 0  THEN BEGIN
	if tmpB.t EQ '2d' then tmpM=tmpB
ENDIF
IF n_tags(tmpM) NE 0 THEN tmpM.d=0 ELSE BEGIN
	 axis_log,'No image selected. Cannot generate RBG composite'
	 RETURN
ENDELSE

IF n_tags(tmpR) EQ 0 then tmpR=tmpM
IF n_tags(tmpG) EQ 0 then tmpG=tmpM
IF n_tags(tmpB) EQ 0 then tmpB=tmpM

IF tmpR.t NE '2d' then tmpR=tmpM
IF tmpB.t NE '2d' then tmpB=tmpM
IF tmpG.t NE '2d' then tmpG=tmpM

; ------- generate display
wset, MainImg
disp3col,tmpR,tmpG,tmpB, /axis_on, channel=3	;displays 3-channel tif


END
