; Copyright (c) 1998-2025  A.P. Hitchcock  All rights reserved
;+
;NAME:
;  STACK_TRANSFORM
;
;LAST CHANGED: ----------------------------------- 12 Feb 2025 (aph)
;
; PURPOSE:
;	This procedure transforms each image of a stack by
; flipping (180 vertical :  X==x,  Y=-Y) or mirroring (180 horizontal;  X==>-X, Y=Y)
;
; CATEGORY:
;	stack processing; stand alone operation
;
; CALLING SEQUENCE:
;	STACK_TRANSFORM, FILE=FILE, FLIP=FLIP, MIRROR=MIRROR
;
; INPUTS: none required
;
; KEYWORDS:
; 	file		name of the input file
;
; OUTPUTS: transformed stack written to folder (add '_f' or '_m' to name)
;
; COMMON BLOCKS:
; AXIS_COM	standard set of common blocks
; stack_process_com
; BSIF_com
; volume_data, image_stack
;
; SIDE EFFECTS: none
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (12-Feb-25 aph) first version
;-

PRO stack_transform, file=file, flip=flip, mirror=mirror, axisID=axisID
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com

on_error,2

; determine if AXIS is running (therefore may have called ax_cgo)
; either when AXIS keyword is supplied or if any widget active
if  keyword_set(axisID) then axis_on = 1 else axis_on = widget_info(/active)

fltr = '*.ncb'

IF not keyword_set(file) then begin
	file = pickfile2(/READ, TITLE = 'STACK to be transformed', FILTER=fltr, /LPATH, DEFPATH=defpath)
	if strlen(file) LE 0 THEN return  ; bail-out if no filename
ENDIF
t=ax_name(file)
file_short=t(1)

stack_rb, file
stack = image_stack
t1 = size(image_stack)
n_cols = t1(1)
n_rows = t1(2)
n_imgs = t1(3)
print, 'stack parameters: n_cols, n_rows, n_imgs ', n_cols, n_rows, n_imgs

; -------------  define modification
trans = 0
IF keyword_set(flip)   then trans=7	      	;tmp.d = rotate(tmp.d,7)		; X1 = X0  and Y1 = -Y0)
IF keyword_set(mirror) then trans=5   		;tmp.d = rotate(tmp.d,5)		; X1 = -X0  and Y1 = Y0)

ax_wait		; turn on hourglass - this could be slow if processing ptycho stacks

FOR i = 0, n_imgs-1 do begin
	image_stack(*,*,i) = rotate(image_stack(*,*,i),trans)
ENDFOR

ax_wait,/off		; turn off hourglass (sometimes sticks on)

; -- write out transformed stack

file = pickfile2(/READ, TITLE = 'name of modified stack', FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file) NE 0 then begin
	t = ax_name(file)
	filename = string(t(0)) + string(t(1)) + '.ncb'
	stack_wb, filename
endif


return
end

