; Copyright (c) 1998-2024 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	READ_SOLEIL_PTYCHO_BGND
;
;
;LAST CHANGED: -----------------------------------  9 Jan 2-24  (aph)

; PURPOSE:
;	This function extracts the average of multiple camera background files written by the Oct-2023
;   version of the ptycho acquisition program
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;
;   RESULT = READ_SOLEIL_PTYCHO_BGND
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS: aXis2000 *.axb image
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (8 Jan 2024 aph) first version

;-

FUNCTION READ_SOLEIL_PTYCHO_BGND, file=file
@axis_com
on_error,2


file=pickfile2()

b= h5_parse(file, /read_data)

; help, b.entry.scan_data ,/struct

bgnd =  b.entry.scan_data.stack_20221009_094_dark_IMAGE._data			;  CHANGE as needed

xp = 1400
yp = 1400
bgnd_avg = fltarr(xp, yp)

n_imgs =25

; bgnd_avg = mean(bgnd, dimension=2)			dimmension only in IDL 8

for i = 0, n_imgs-1  do begin
	bgnd_avg = bgnd_avg + bgnd(*,*,i)
endfor

bgnd_avg = bgnd_avg/n_imgs
bgn_avg = bgnd(*,*,1)

; ----  write to an aXis2000 *.axb file

x = findgen(xp)   &  y =  findgen(yp)
energy = 900.

tmp = {t:'2d', x:x, y:y, xl:'x', yl:'y', e: energy, d: bgnd_avg, dl:'STACK_20221009_094_DARK_IMAGE'}

tvscl, tmp.d

; help, tmp, /struct

t = axb_save(tmp)
return, t

END

