; Copyright (c) 1998-2010 J. Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;	XSPECSIM_RUN.PRO
;
;LAST CHANGED: -------------------------  19-Jul-10
;
;PURPOSE:
; This procedure loads XSpecSim 
; with optional path to configuration file
; if running as part of axis
;
;CATEGORY:
;	STAND ALONE: Spectra Prediction
;
;CALLED FROM:  Axis2000
;
; CALLING SEQUENCE:
; XSPECSIM_RUN, FILE=FILE, AXIST=AXIST
;
;INPUTS: none
;
; KEYWORDS
; FILE  fillename
; AXIST replacement for aXisR
; 
;OUTPUTS: none
;
;COMMON BLOCKS:
; axis_com
;	@XSpecSim_Com		X-SpecSim common block
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (10-Jul-10 aph) AXIS standard header added; name changed

pro XSpecSim_run, file=file, AxisT=AxisT
@axis_com
@XSpecSim_Com

if not Keyword_set(file) then begin
  file='AAData\'
endif
if not keyword_set(AxisT) then begin
   AxisR=0
endif else begin
   AxisR=AxisT
endelse

print, axisr

XSpecSim_init, file=file

if  keyword_set(axisT) then axis_on = 1 else axis_on = widget_info(/active)
if (axis_on) then $
  XSpecSim, group_leader=axis_ID, file=codePath + 'AAData' + ax_sep() $
  else XSpecSim
End