; Copyright (c) 1998-2010 J. Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PARSECOMPOSITION.PRO
;
;LAST CHANGED: ----------------------------------- 	19-Jul-10
;
; PURPOSE:
;	This function string containing chemical composition data
; and returns number of H,C,N,O,S,P  (NB there is a similar function in SF)
;
; CATEGORY:
;	Utility; part of XSpecSim, spectral simulator package
;
; CALLING SEQUENCE:
;	Result = PARSECOMPOSITION(strdat =strdat)
;
; INPUTS: none
;
; KEYWORDS:
;	STRDAT 	String with composition in standard periodic table notation
;
; OUTPUTS: none
;
;COMMON BLOCKS:
;	@XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added; XSpecSim_com added
;-


function ParseComposition, strdat =strdat
@XSpecSim_Com

comp = {carbon:0, nitrogen:0, oxygen:0, hydrogen:0, sulphur:0, phosphorus:0}
strdat = strdat + ' '
strbyte = byte(strdat)
count = strlen(strdat)

elements = ['C','N', 'O', 'H', 'S', 'P']
elementsV = fltarr(6)
elementsV[*] = 0

j=0
for i = 0, n_elements(elements)-1 do begin
	pos = strpos(strdat, elements[i])
	if (pos ne -1) then begin
		if (pos ne strlen(strdat) - 1) then begin
			if ((strbyte[pos+1] gt	45) and (strbyte[pos+1] lt 58)) then begin
				j=0
				while ((j lt count-pos-1) and (strbyte[pos +1+ j] gt 45) and (strbyte[pos +1+ j] lt 58)) do begin
					j = j+1
				endwhile
				if j eq 0 then j =1
				elementsv(i) =float(strmid(strdat,pos+1,j))
			endif else begin
				elementsv(i)=1
			endelse
		endif else begin
			elementsv(i)=1
		endelse
	endif
endfor

comp.Carbon = elementsv(0)
comp.Nitrogen = elementsv(1)
comp.Oxygen = elementsv(2)
comp.hydrogen = elementsv(3)
comp.sulphur = elementsv(4)
comp.phosphorus = elementsv(5)
return, comp
end