; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		MAKE_TOMO_LIST
;
;LAST CHANGED: ----------------------------------- 	14-Nov-2013
;
; PURPOSE:
;	This procedure generate a list of folder names of stacks recorded at specific angles
; the file is needed for ther manipulations of the data.
;
; CATEGORY:
;	stand alone Utility
;    called from aXis2000 by stack~tomography~make_tomo_list.
;
; CALLING SEQUENCE:
;	Make_tomo_list [FILE=FILE, FOLDER_NAME=folder_name,ANGLE=angle ]
;
; INPUTS:
;   None
;
; KEYWORDS:
;   FILE - name of file to write out
;	FOLDER_NAME - tomo file folder name
;   ANGLE - all the angles for tomo file
;
; OUTPUTS:
;	Tomo list as a *.lst file is written to disk
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; EXAMPLE:
;	Generate a list with path as first line then a set of lines
; with each line as following:
;		folder_name(),angle()
;
; MODIFICATION HISTORY:
; (06-Nov-13 jw) first generation
; (14-Nov-13 jw) output and write data to file
;-


PRO MAKE_TOMO_LIST, file=file, folder_name=folder_name, ANGLE=angle
@axis_com
on_error,2


;get the path of the file folder
directory=Dialog_Pickfile(/Directory);get the directory of the tomo list
print,directory

;make the folder_name list
;get all the file name in the directory of the tomo list (unless supplied)
if not keyword_Set(folder_name) then folder_name=file_basename(file_search(directory,'',count=num,/test_directory))

;create the angle_list (unless supplied)
if not keyword_Set(angle) then begin
	a=findgen(num)
	if widget_info(/active) EQ 0 then $
		start_angle = Get_text(PROMPT = 'start angle', val = start_angle) $
			else start_angle = Get_text(PROMPT = 'start angle', val = start_angle, group = axis_ID)
	if widget_info(/active) EQ 0 then $
		step = Get_text(PROMPT = 'step angle', val = step) $
			else step = Get_text(PROMPT = 'step  angle', val = step, group = axis_ID)

	;get the angle value as a array
	angle=a*step + start_angle
endif

;print the folder_name_angle list
for i=0,num-1 do print,folder_name(i),angle(i)

; get output filename
if not keyword_set(file) then begin
	fltr='*.lst'
	if keyword_set(nof) then fltr='*'
	filename = pickfile2(/write, FILTER=fltr, /LPATH, DefPath=WritePath) ;, get_path=WritePath)
	print, 'DefPath changed to ', DefPath
endif

if strlen(filename) EQ 0 then return

t=ax_name(filename)
filename = t(0) + ax_sep() + t(1) + '.lst'

; write data to file

OPENW, iunit, filename, /GET_LUN
printf,iunit, directory
for i=0,num-1 DO BEGIN
	printf,iunit, folder_name(i),', ',angle(i)
endfor
close, iunit & free_lun, iunit

axis_log, 'folder list for tomo wrote to ' + t(1) + '.lst'

end
