PRO Stack_psprint, list_filename, psfilename=psfilename, $ 
                   dpi=dpi, noprint=noprint, bits=bits, help=help 
 
IF keyword_set(help) THEN BEGIN 
    print,'stack_psprint,[list_filename],[psfilename=,dpi=,/noprint,bits=]' 
    return 
ENDIF 
 
@bsif_com 
 
IF (NOT keyword_set(dpi)) THEN dpi = 100 
IF (NOT keyword_set(noprint)) THEN noprint = 0 
IF (NOT keyword_set(bits)) THEN bits = 8 
 
osname = strupcase(strmid(!Version.os, 0, 3)) 
 
IF (n_elements(psfilename) EQ 0) THEN BEGIN 
    IF (osname EQ 'VMS') THEN BEGIN 
        print_string = 'print/delete/que=lpp ' 
    ENDIF ELSE BEGIN 
        print_string = 'lpr -Px1 -r -h ' 
    ENDELSE 
    psfilename = randomfile() 
ENDIF ELSE BEGIN 
    IF (osname EQ 'VMS') THEN BEGIN 
        print_string = 'print/que=lpp ' 
    ENDIF ELSE BEGIN 
        print_string = 'lpr -Px1 -h ' 
    ENDELSE 
ENDELSE 
 
stack_readlist, list_filename, filename_list 
 
n_files = n_elements(filename_list) 
 
IF (n_files LT 2) THEN BEGIN 
    print,'No files in list for printing!' 
    return 
ENDIF 
 
; for 72 point font 
text_yinch = 10./72. 
border_inch = 18./72. 
xpi = 8.5 
ypi = 11. 
xpi_offset = 0.5 
ypi_offset = 0.75 
xpi_size = xpi-2.*xpi_offset 
ypi_size = ypi-2.*ypi_offset 
 
FOR i_file = 0, (n_elements(filename_list)-1) DO BEGIN 
    read_stxm, filename_list(i_file), sd, khz,/nocopybytes 
    ev_string = $ 
      strtrim(string((12398.52/sd.wavelength), format = '(f10.2)'), 2)+$ 
      ' eV' 
    IF (i_file EQ 0) THEN BEGIN 
        ximinch = float(n_cols)/float(dpi) 
        yiminch = float(n_rows)/float(dpi) 
        yboxinch = yiminch + 3.75*text_yinch + border_inch 
 
        nx_per_page = fix((xpi_size-border_inch)/(ximinch+border_inch)) 
        ny_per_page = fix((ypi_size-border_inch)/(yboxinch+border_inch)) 
        n_pages = (fix(0.99+float(n_files) / $ 
                       float(nx_per_page*ny_per_page)) > 1) 
        print, 'Will make '+strtrim(string(n_pages), 2)+' pages with '+$ 
          strtrim(string(nx_per_page), 2)+' x '+$ 
          strtrim(string(ny_per_page), 2)+' images/page' 
 
        old_plot = !D.name 
        old_font = !P.font 
        set_plot, 'ps' 
        !p.font = 0 
        device, file = psfilename, /inch, xsize = xpi_size, ysize = ypi_size, $ 
          xoffset = xpi_offset, yoffset = ypi_offset, bits = bits 
 
        bar_microns = fix(0.5+0.25*abs(x_stop-x_start)) 
        bar_inches = ximinch*float(bar_microns)/float(abs(x_stop-x_start)) 
        bar_string = strtrim(string(bar_microns, $ 
                                    format = '(i6)'), 2)+' microns' 
 
        i_row = 0 
        i_col = 0 
    ENDIF 
 
    xpos = i_col*(ximinch+border_inch) 
    ypos = ypi_size-(i_row+1)*yboxinch 
    xyouts, (xpos/xpi_size), (ypos/ypi_size), /norm, filename_list(i_file) 
    ypos = ypos + 1.25*text_yinch 
    xyouts, (xpos/xpi_size), (ypos/ypi_size), /norm, ev_string 
    ypos = ypos + 1.25*text_yinch 
    tv, bytarr(1, 1), xpos, ypos, $ 
      xsize = bar_inches, ysize = 0.5*text_yinch, /inch 
    xpos = xpos + text_yinch + bar_inches 
    xyouts, (xpos/xpi_size), (ypos/ypi_size), /norm, bar_string 
    xpos = i_col*(ximinch+border_inch) 
    ypos = ypos + 1.25*text_yinch 
    tv, bytscl(khz), xpos, ypos, xsize = ximinch, ysize = yiminch, /inch 
 
    i_col = i_col + 1 
    IF (i_col EQ nx_per_page) THEN BEGIN 
        i_col = 0 
        i_row = i_row + 1 
        IF (i_row EQ ny_per_page) THEN BEGIN 
            erase 
            i_row = 0 
        ENDIF 
    ENDIF 
ENDFOR 
 
device, /close 
 
set_plot,old_plot 
!p.font = old_font 
 
IF (noprint EQ 0) THEN BEGIN 
    print, 'Doing "'+print_string+psfilename+'"' 
    spawn, print_string+psfilename, result 
ENDIF 
 
return 
END 
 
 
 
 
 
 
 
 
 
 
 
 
 
