; Copyright (c) 1998-2010 J. Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;	XSPECSIM_INIT.PRO
;
;LAST CHANGED: ----------------------------------- 23-Jul-10
;
;PURPOSE:
; Reads the configuration file for XSpecSim
;
; CATEGORY:
; Utility; part of XSpecSim, spectral simulator package
;
;CALLED FROM XSpecSim_run:
;
;OUTPUTS: none
;
;COMMON BLOCKS:
;	@XSpecSim_Com		X-SpecSim common block
;	
;	MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (19-Jul-10 aph) AXIS standard header added;
;      changed from AA_init to XSpecSim_Init
; (23-Jul-10 aph) modified path definitions to work wih CodePath 
;           without assuming code is in c:\aXis2000\
;-

Pro XSpecSim_Init, file=file
@XSpecSim_Com

ProteinName=''

if not Keyword_set(file) then begin
  File='AAData' + ax_sep()
endif
If n_elements(CodePath) EQ 0 then CodePath = 'C:\Axis2000\'
initfile=CodePath + File + 'AA_Init.ini'
sf_path = CodePath + 'sfdata' + ax_sep()
	if strlen(initfile) GT 0 then begin
	  	openr, iunit, initfile, /get_lun
	  	test=''
	  	readf, iunit, test
		test = strtrim(test,2)
		Curdat=long(test)
		readf, iunit, test
		test = strtrim(test,2)
		Curen =long(test)
		readf, iunit, test
		test = strtrim(test,2)
		saveSF=long(test)
		readf, iunit, test
		test = strtrim(test,2)
		BasePath= test
		readf, iunit, test
		test = strtrim(test,2)
		sf_Path= test
	  	close, iunit & free_lun, iunit
	  endif

    eFileList = FINDFILE(CodePath+File + '*.aah')
    j=long(0)
	if n_elements(eFileList) gt 0 then begin
	  	test[0]=''
	  	datafiles=strarr(1000)
	  	datapaths=strarr(1000)
	    While j lt n_elements(eFileList) do begin
			openr, iunit, eFileList[j], /get_lun
			readf, iunit, test
			test = strtrim(test,2)
			datafiles[j]=test
			;datapaths[j]=basepath + eFileList[j]
			datapaths[j]= + eFileList[j]
			j=j+1
			close, iunit & free_lun, iunit
		endwhile
	  	datafiles=datafiles(0:j-1)
	  	datapaths=datapaths(0:j-1)
	endif


	eFileList = FINDFILE(CodePath + File + '*.enf')
	j=long(0)
	if n_elements(eFileList) gt 0 then begin
	  	test=''
	  	enfiles=strarr(1000)
	  	enpaths=strarr(1000)
	    While j lt n_elements(eFileList) do begin
			openr, iunit, eFileList[j], /get_lun
			readf, iunit, test
			test = strtrim(test,2)
			enfiles[j]=strmid(test[0],14,strlen(test)-14)
			;enpaths[j]=basepath + eFileList[j]
			enpaths[j]=eFileList[j]
			j=j+1
			close, iunit & free_lun, iunit
		endwhile
		enfiles=enfiles(0:j-1)
	  	enpaths=enpaths(0:j-1)
	endif
end

