pro stack_plot_spectrum, nc_file, $ 
                         smoothing=smoothing, overlay=overlay, $ 
                         epsfile=epsfile 
 
IF (n_params() EQ 0) THEN BEGIN 
    print,'stack_plot_spectrum, nc_file [smoothing=,/overlay,epsfile=]' 
    print,'    For smoothing=, give an integer box width' 
    print,'    /overlay will show both raw and smoothed data' 
    return 
ENDIF 
 
@bsif_com
 
IF (NOT keyword_set(smoothing)) THEN smoothing=0 
IF (NOT keyword_set(overlay)) THEN overlay=0 
 
old_plot = !d.name 
old_font = !p.font 
 
read_stxm,nc_file,sd,khz 
ev=12398.52/x_dist 
 
thick=2 
IF keyword_set(epsfile) THEN BEGIN 
    set_plot,'ps' 
    device,file=epsfile,/encap,xsize=5.,ysize=3.5,/inch,/preview 
    !p.font = 0 
    thick=4 
ENDIF 
 
IF (smoothing EQ 0) THEN BEGIN 
    plot,ev,khz,xtitle='eV',title=nc_file 
ENDIF ELSE BEGIN 
    IF (overlay EQ 0) THEN BEGIN 
        plot,ev,smooth(khz,smoothing),xtitle='eV',title=nc_file 
    ENDIF ELSE BEGIN 
        plot,ev,khz,xtitle='eV',title=nc_file,psym=1 
        oplot,ev,smooth(khz,smoothing) 
    ENDELSE 
ENDELSE 
 
IF keyword_set(epsfile) THEN BEGIN 
    device,/close 
    set_plot,old_plot 
    !p.font=old_font 
ENDIF 
 
return 
END 
 
