PRO Read_sxm, filename, $
              header_only=header_only, $
              print_header=print_header, $
              output_lun=output_lun, $
              display_image=display_image, $
              help=help

@bsif_common
@sxm_common
@sxm_acommon

IF (keyword_set(help) OR (n_elements(filename) EQ 0)) THEN BEGIN
    print, 'read_sxm,filename'
    print, '  keywords [/header_only,/print_header,/display_image]'
    print, '  You can then get at data_image array by invoking'
    print, '    IDL> sxm_inorm,/all'
    print, '    IDL> img_scl,data_image'
    return
ENDIF

IF keyword_set(header_only) THEN BEGIN
    IF (sxm_readfile(filename, error_message, /header_only) EQ 0) THEN BEGIN
        print, error_message
        return
    ENDIF
ENDIF ELSE BEGIN
    IF (sxm_readfile(filename, error_message) EQ 0) THEN BEGIN
        print, error_message
        return
    ENDIF
ENDELSE

IF keyword_set(print_header) THEN BEGIN
    IF (NOT keyword_set(output_lun)) THEN output_lun = -1 ; terminal
    sxm_printpar, lun = output_lun, /brief
ENDIF

IF keyword_set(display_image) THEN BEGIN
    sxm_inorm, /all
    
    IF (strupcase(string(sxm_par.scanmode)) EQ 'SPEC') THEN BEGIN
        ;; It is a spectrum scan, so we have a plot
        npts = n_elements(data_image)
        nm = sxm_par.start_nm+(sxm_par.end_nm-sxm_par.start_nm)*$
          findgen(npts)/float(npts-1)
        ev = 1239.852/nm
        plot, ev, data_image, xrange = [min(ev), max(ev)], $
          yrange = [sxm_par.disp_min, sxm_par.disp_max], $
          xtitle = 'Energy (eV)', $
          ytitle = string(sxm_par.disp_mode)
    ENDIF ELSE BEGIN
        img_scl, ((data_image-sxm_par.disp_min) / $
                  (sxm_par.disp_max-sxm_par.disp_min))^sxm_par.disp_gamma, $
          min = 0., max = 1., /scalebar
    ENDELSE
ENDIF

return
END


