; Copyright (c) 1998-2002 A.P. Hitchcock  All rights reserved
;+
;NAME:
; 		LOAD_NEX
;
;LAST CHANGED: ----------------------------------- 	13-may-02
;
; PURPOSE:
;	This function loads nexafs spectra recorded by ALS SPEM
;
; CATEGORY:
;	read-in utility. Stand-alone
;
; CALLING SEQUENCE:
;	Result = load_nex (file, NOFILTER=nof, _extra=e)
;
; INPUTS:
; FILE - name of file (*.spc)
;
; KEYWORDS:
;	NOFILTER
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (12-may-99 aph) first written
; (8-jun-99 aph) add conditional group ID to get_num call; widget_info
; (29-dec-00 aph) filter set to '*.spc'
; (12-may-02 aph) AXIS standard header added
;-
function load_nex, file, NOFILTER=nof, _extra=e
on_error,2
@axis_com

if n_elements(file) eq 0 then begin  ;popup file dialog box
   fltr='*.spc'
   if keyword_set(nof) then fltr='*'
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath)
endif
s = 0
IF strlen(file) GT 0 THEN BEGIN
	a = gen_read(file)
	x = reform(a.indvars(0,*))
	t = size(a.singlenames)  & n_spectra = t(1)
	d = reform(a.singledata(1,*))
	dn = reform(a.singledata(0,*))
	dl = a.fname
	xl = 'Photon Energy (eV)'
	print, 'ALS SPEM NEXAFS read in:'
	print, '    Select: 0 = norm; 1 = sample TEY, 2 = ratio'
	text = string(' ',format="('Select channel',/,' 0 = norm',/,' 1 = sample TEY',/,' 2 = ratio',a1)")
	 WIDGET_CONTROL, Uprompt, BAD_ID = BadID, Set_Value = text
	if widget_info(/active) EQ 1 then begin
		nc = get_num(VAL = 2, prompt = 'select data channel', group = axis_id)
	endif else	nc = get_num(VAL = 2, prompt = 'select data channel')
	if nc EQ 0 then d = dn
	if nc EQ 2 then d = d/dn
	s = {t:'1d', x: x, d: d, xl: xl, dn: d,  dl: dl}
	print, dl, 'SPEM TEY-NEXAFS from:', s.x(0), ' to ', s.x(n_elements(s.x)-1)
ENDIF

return, s
end

