


PRO ax_txm_read_demo


; The Java class txmreader creates a java list of java objects, one
; for each image stored in the txrm file
; create the Java object
oJTxmImgFactory = OBJ_NEW("IDLJavaObject$TXMREADER_TXMIMAGEFACTORY", "txmreader.TxmImageFactory")
; assign the filename
filename=pickfile2()
oJFullTXMData = oJTxmImgFactory -> getData(filename)
; this object is an IDLJAVAOBJECT$JAVA_UTIL_ARRAYLIST
; for methods see: http://docs.oracle.com/javase/6/docs/api/java/util/ArrayList.html
; now get the number of images inside
NoOfImages = oJFullTXMData -> size()
; get data for all images: NOTE indexing starts from 0
for ii=0,NoOfImages-1 do begin
    PRINT, ii, '--------'
    oJTxmImg = oJFullTXMData -> get(ii)
    ; this is now an IDLJavaObject$TXMREADER_TXMIMAGE
    PRINT, oJTxmImg -> getPixelSize()
	PRINT, oJTxmImg -> getAngles()
	PRINT, oJTxmImg -> getAxisNames()
	PRINT, oJTxmImg -> getMotorPositions()
	PRINT, oJTxmImg -> getScanSize()
	h = oJTxmImg -> getImageHeight()
	w = oJTxmImg -> getImageHeight()
	; and so on ...

	; read the image
	img = oJTxmImg -> getPixels()
	; and display in an IDL window:
	WINDOW, ii, XSIZE=w, YSIZE=h
	TVSCL, REBIN(img,h,w )
endfor


; Cleanup the object.
OBJ_DESTROY, oJTxmImgFactory
OBJ_DESTROY, oJFullTXMData
OBJ_DESTROY, oJTxmImg
END