; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_IMSCL 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
;PURPOSE: 
;	This function maps the intensity values of an image 
; to a reduced byte_scale: (0 is set to top_color_index, not 255) 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	Result = ax_imscl(G_data) 
; 
;CALLED FROM AXIS: 
;	->Stacks->bin NSLS->{1,file} 
 
;INPUTS: 
;	G_data - 2d image array 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	Result, the re-scaled data array 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
;	If needed, modify ax_color.pro to set ax_top_color_index 
; and the number/values of reserved colors 
; 
;MODIFICATION HISTORY: 
; (25-jun-99 aph) first version; from zstack_spectra.pro 
; (01-jul-99 aph) adapt for hard colors low 
; (31-dec-99 aph) AXIS standard documentation 
;- 
 
Function ax_imscl, G_data 
 
@axis_com
on_error,2 
 
; ----------- rescale data to map to [ax_low_color_index,ax_top_color_index] ------------- 
this_image = G_data 
min_image = min(this_image) 
this_image = this_image - min_image 
max_image = max(this_image) 
percent_image = 100 * this_image / max_image 
disp_min = 0. 
disp_max= 100. 
disp_gamma = 1. 
zdata = ax_low_color_index + byte(0.5+float(ax_top_color_index - ax_low_color_index)* $ 
			(( (((percent_image - disp_min) / $ 
				float(disp_max - disp_min))^disp_gamma) $ 
				>0.)<1.))<byte(ax_top_color_index) 
;print, 'transformed data min/max: ', min(zdata), max(zdata) 
return, zdata 
end 
