FUNCTION ax_fix_rollover_test, one=one, user=user

@axis_com
@bsif_com
on_error,2


s = 0	; default return ==>    did not execute

; ------- define threshold and offset
IF keyword_set(user) then begin			; user defined low_limit and roll_over increment
	low_limit = 4
	roll_over = 6.283 		; 2pi = 6.28318530718
endif else begin			; default for 2**16 - 1 rollover
	low_limit = 0
	roll_over = 65535.
endelse
; ; use TOF parameters to (re)-store threshold & offset
if n_elements(stop1) GT 0 then threshold = stop1 else threshold = low_limit
if n_elements(stop2) GT 0 then    offset = stop2 else offset = roll_over

; --------- set up threshold and offset ---------

 threshold = get_num(Prompt = 'Threshold for CHANGE', Val=threshold, Title='Fix rollover - threshold', group = Axis_ID)
 offset = get_num(Prompt = 'Offset', Val=offset, Title='Fix rollover - offset', group = Axis_ID)

stop1 = threshold
stop2 = offset

; -------- process file in the current buffer in aXis2000
IF keyword_set(one) then BEGIN
	HANDLE_VALUE, Data(CurBuf), tmp
    IF n_tags(tmp) EQ 0 THEN RETURN, s
    IF tmp.t NE '2d' THEN RETURN, s
	fix_rollover, tmp
	return, tmp

ENDIF ELSE BEGIN

; fix rollowver for a sequence of files in a stack, or listed in a stack list (*.sl) file

; code to switch *.sl, versus *.(dat.ncb)

; ---------------- apply fix rollover to a set of *.axb files, defined by a stack list (*.sl) file
; ----- read stack list
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'Select file-list file'
	list_file = pickfile2(/READ, FILTER='*.sl',/LPATH, DEFPATH=defpath)
	Write_path = Lpath
	IF strlen(list_file) EQ 0 THEN return, s
; ------ read in the *.sl file
	stack_readlist,list_file, filename_list
	if n_elements(filename_list) LE 1 then begin
		axis_log, 'Could not read ' + list_file
		return, s 	; BAIL if no files
	endif
	filename_list_out = strarr(n_elements(filename_list))

	FOR loop = 0, n_elements(filename_list)-1 do begin
		WIDGET_CONTROL, /hourglass
		tmp = axb_load(file=filename_list(loop), /silent)
		IF n_tags(tmp) EQ 0 THEN RETURN, s
	    IF tmp.t NE '2d' THEN RETURN, s

		tmp = fix_rollover(tmp)

; --------------- write out the result
		tmp.dl = tmp.dl + ' FixR'
		CurBuf = 0
		HANDLE_VALUE, Data(CurBuf), tmp, /set
		PlotBuf,CurBuf
		 t = ax_name(filename_list(loop))
		 filefix= t(0) + 'm_' + t(1) + '.axb'
		 tf=axb_save(tmp, file=filefix, /silent)
		 t = ax_name(filefix)
		 filename_list_out(loop)=t(1) + '.axb'
		 axis_log, filename_list_out(loop)
	ENDFOR

	; ------ write out stack list file of modified images ----------
	t = ax_name(list_file )
	out_list_file = t(0) + 'm_' + t(1) + '.' + t(2)
	openw,unit, out_list_file,/get_lun
	printf,unit,t(0)
	for i = 0, n_elements(filename_list_out)-1 do begin
		printf,unit, filename_list_out(i)
	endfor
	close,unit & free_lun, unit
	t = ax_name(out_list_file)
	print, 'Stack list file for modified images is ', out_list_file
	s = 1
	RETURN, out_list_file
ENDELSE
END