;+ 
;NAME: 
;	TEXT_READ.PRO 
; 
;LAST CHANGED: ----------------------------------- 11-nov-00 
; 
;PURPOSE: 
;	TEXT_READ - multi-block file read-in 
; 
;CATEGORY: 
;	STAND ALONE: utilities 
; 
;CALLING SEQUENCE: 
;	Result = text_READ(FILNENAME)  
; 
;CALLED FROM AXIS: 
;	many procedures 
; 
;ROUTINES 
;	function TEXT_READ, FNAME, block=b, blkInfo=bi 
;	reads the bth block (starting from zero) in the file 
; and returns the contents as a matrix 
; KEYWORDS: 
;	BLOCK - block number to read 
;	BLKINFO - string array for header information for block 
; 
;COMMON BLOCKS: none 
; 
;----------------- 
; FILE ROUTINES -- eli's text format 
;----------------- 
;file structure- 
;line 0: number of items 
;line 1: string=name of first item 
;line 2: size(item) 
;line 3: item, space-delimited 
;line 4: string=name of next item 
;    : 
;    : 
; 
;MODIFICATION HISTORY: 
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in 
; (26-feb-00 aph) AXIS standard documentation 
; (11-nov-00 cgz) migrated from former FILE.PRO
;- 
; ******************************************************************************* 

function text_read, fname, block=b, blkInfo=bi 
; reads the bth block (starting from zero) in the file and returns as a matrix 
 
  on_error,2 
  if keyword_set(bi) eq 0 then a=chkfileblocks(fname) else a=bi 
  if keyword_set(b) ne 0 then begin 
    start=a(b,2) 
    nrow=a(b,0) 
    ncol=a(b,1) 
  endif else begin 
    start=a(0,2) 
    nrow=a(0,0) 
    ncol=a(0,1) 
  endelse 
  openr, unit, fname, /get_lun 
  if start gt 0 then begin 
    s=strarr(start) 
    readf,unit,s 
  endif 
  ans=fltarr(ncol, nrow) 
  readf,unit,ans 
  as=size(ans) 
  if (as(0) eq 1) and (as(1) eq 1) then ans=ans(0,0) ;single #,convert to scalar 
  if (as(0) eq 2) and (as(1) eq 1) then begin 
    ;single column, convert to 1-dim array 
    b=fltarr(as(2)) 
    for i=0,as(2)-1 do b(i)=ans(0,i) 
    ans=b 
  endif 
  close, unit 
  free_lun,unit 
  return,ans 
end 
 
