; Copyright (c) 1998-2024 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	READ_PYSTXM_COARSE.PRO
;
;
;LAST CHANGED: ----------------------------------- 	31 Jan  2024 (aph)

; PURPOSE:
;	This procedure reads in *.hdf5 files written by pySTXM 2.5 where the image data is 1-d
; according to HDFView 2.11 and when read in with ax_nexus, only displays 1 y-value
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;   RESULT = READ_PYSTXM_coarse(file)
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS:
;
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (31-Jan-24 aph) first version

;-

FUNCTION READ_PYSTXM_coarse,  file
@AXIS_COM
@nexus_com

; require caller program to supply file
t = ax_name(file)
fileshort = t(1)
print, fileshort, '  : reading in images [or focus scans] using coarse motor (>50 um) written by pySTXM 2.5'

a=h5_parse(file, /read_data)

scan_type =  a.entry0.counter0.stxm_scan_type._data
x = a.entry0.counter0.sample_x ._data
y = a.entry0.counter0.sample_y ._data
energy = a.entry0.counter0.energy ._data			; in eV
if scan_type EQ 'sample focus' then begin
	yl = 'Polarization:  undefined'
endif else begin
	pol = a.entry0.counter0.epu_polarization._data
	yl = 'Polarization   ' + strtrim(string(fix(pol)))		;  LATER translate to actual polarization
endelse

dwell = 1000*a.entry0.counter0.count_time ._data	; in sec
d =  a.entry0.counter0.data._data
nx = n_elements(x) & ny = n_elements(y)
xl = string(nx, ny, energy, dwell, format= '(i4," x",i4," pixels. E =",f7.2," eV. Dwell =",f5.2," ms.")')

tmp = {t:'2d', x:x, y:y, d:d, dn:d, e: energy, xl:xl, yl:yl, dl:fileshort}

if scan_type EQ 'coarse image scan' then make_square,tmp

return, tmp

end
