; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PRINT.PRO
;
;LAST CHANGED: ----------------------------------- 	21 Jul 2014
;
; PURPOSE:
;	These functions print. Probably not called anywhere in aXis2000
;
;  pro PRA, /LS, /EPS, _extra=e
;	OPEN POSTSCRIPT FILE FOR OUTPUT
;	OPTIONS: /LS (landscape), /EPS (encapsulated postcript)
;  pro PRB, 'printer', /NOPRINT
;	CLOSE & PRINT to 'BL7LJ4' (default), 'hp9', etc.
;

; MODIFICATION HISTORY:
; (29nov00 cgz) Only PRa and PRb are used anywhere within AXIS
;			PRa and PRb are called once from within WINDOW.PRO
;			Migrated PRa and PRb to WINDOWS.PRO
; (22-Jul-14 aph) AXIS standard header added
;			pra is called by win3lpr which is used in axis_c to print
;-


pro PRa, LS=ls, EPS=eps, _extra=e
;--------------------------------
  cmd='set_plot,''ps'' & device, bits=8'
  if keyword_set(ls) eq 1 then cmd=cmd+', /landscape'
  if keyword_set(eps) eq 1 then cmd=cmd+', /encapsulated,/preview'
  cmd=cmd+', _extra=e'
  print, cmd
  dum=execute( cmd )
  return
END


pro PRb, printer, NOPRINT=nopr
;----------------------------
device,/close
set_plot,'x'
if keyword_set(printer) then pr=printer else pr='6-BL7LJ4M+' ;'hp9','xm1_hp'
if keyword_set(nopr) eq 0 then begin
  pcmd='lpr -P'+pr+' idl.ps'
  print,pcmd
  spawn,pcmd
endif
;retall
END

;---- delete later ---
pro PRls,_extra=e
   set_plot,'ps'
   device,bits=8,/landscape,_extra=e
end

pro PReps,_extra=e
   set_plot,'ps'
   device,bits=8,/encapsulated,/preview,_extra=e
end




