; Copyright (c) 1995, ALS SpectroMicroscopy Facility, er, jdd 
;+ 
;NAME: 
;	GEN_READ 
; 
;LAST CHANGED: ----------------------------------- 15-nov-00
; 
;PURPOSE: 
;	This function reads general ALS BL7 XPS labview format files into a data structure 
;   uses pickfile2() to select input file if fname not specifed 
; 
;CATEGORY: 
;	STAND ALONE: utility (als) 
; 
;CALLING SEQUENCE: 
;	Result = GEN_READ(FNAME, /options) 
; 
;CALLED FROM AXIS: 
;	->Read->Spectra->ALS SPEM 
; 
;INPUTS: 
;	FNAME - filename (optional; if not provided, uses pickfile2) 
; 
;KEYWORDS: 
;	INFO - print information about routine 
;	QUIET - no logging comments 
;	PATH - path for data file 
;	PLOT - plot data 
;	DEBUG - turn on debugging code 
;	NOREFORM - do not reform the output data array 
;   TIME=timestr - returns 'Aq. End' date and time string from line 7 
; 
;OUTPUTS: 
;	The result is a data structure specific to ALS BL 7 XPD and SPEM 
; electrn spectroscopy data. (recorded with 16-channel PHI analyser) 
;	 answer={fname:fname, summary:summ, phiDescr:phiDesc, $ 
;     IndNames:indnam, IndVars:indv, $ 
;     SingleNames:singnam, singleData:singDat, $ 
;     NormNames:normnam, norm1Dim:norm1D,  RgnInfo:rgninfo, $ 
;     x:-1.*xData, y:yData, yn:ynData} 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;RESTRICTIONS: 
;	** doesn't read multiple  (non-VF files properly) 
; 
;MODIFICATION HISTORY: 
; (xx-mmm-95  er)  created 
; (03-dec-95  jd)  added REFORM(xdata,ydata,yndata) in gen_read 
; (xx-aug-96  jd)  fixed up bugs in reading MgKa data 
;                  still problems with multiple spectral ranges 
; (xx-dec-96  er)  fixed reading of multiple spectral region files(?) 
; (13-feb-97  jd)  added recognition of Quadrupole scan; returns -1 
; (16-feb-97  er)  added keyword NOREFORM 
; 					added recognition of snapshots (have shorter rgninfo) 
; (07-apr-98  er) fixed a bug with multiple regions. 
; (31-JAN-99  er)  changed max line length 32K --> 64K 
; (27-feb-00 aph) AXIS standard documentation 
; (15-nov-00 cgz) Replaced call of NCOLS function by explicit (SIZE(var))(1)
;- 
 
function GEN_READ, fname, PATH=path, PLOT=plot, $ 
         QUIET=qu, DEBUG=debug, TIME=timestr, NOREFORM=noref, _extra=e	  ;, PC=pc (?) 
 
if not keyword_set(debug) then debug=0 
if not keyword_set(fname) then $ 
   fname=pickfile2( /LP, /noconfirm) $ 
else begin 
   if keyword_set(path) then begin 
      nch=strlen(path) 
      if strmid(path, nch-1, 1) ne '/' then path=path+'/' 
      fname=path+fname 
   endif 
endelse 
;  if not keyword_set(fname) then fname=pickfile2( /LP, _extra=e ) 
if strlen(fname) eq 0 then return,0 
openr,unit,fname,/get_lun 
s='' 
readf,unit,s 
version=float(strmid(s,2,strlen(s)-2)) 
;for i=2,7 do readf, unit, s 
readf, unit, s 
readf, unit, s 
if (strmid(s,0,2) eq 'xy') then begin 
   print, 'XY Quadrupole scan' 
   return, -1 
endif 
for i=4,7 do readf, unit, s 
spos=strpos( s, ':', 0 ) 
timestr=strmid(s,spos+2,strlen(s)-2) 
if debug then print, timestr 
 
;SUMMARY 
dummy=read_untilstring(unit,'Summary') 
summ=fix(read_numbers(unit,9))		;integer 
if debug then print,'++ Summary',summ 
 
;HARDWARE (PhiDescr) -- only exists if spectra exist 
phiDesc=0 
dummy=read_until_nochar(unit,';') 
if version ge 2.01 then num=9 else num=8 
if dummy eq 'PhiDescr' then $ 
      phiDesc=read_numbers(unit,num) 
if debug then print,'++ PhiDescr ',phiDesc 
 
;SINGLESHOT (optional) 
ncy=summ(1) ; total # cycles 
nc=summ(2)  ; total # columns 
ni=summ(3)  ; # indvars 
nd=summ(4)  ; # data cols 
nn=summ(5)  ; # norm cols 
 
if nc gt 0 then begin 
    if n_elements( PhiDesc) gt 1 then $ 
        dummy=read_until_nochar(unit,';') 
    if debug then print,byte(dummy) 
    arr=fltarr(nc,ncy) 
;print,dummy 
    names=str_sep(strtrim(dummy,1), ' ') 
;print,names 
    if debug then print,names 
    if ni gt 0 then indNam=names(0:ni-1) else indnam='' 
    if nd gt 0 then singNam=names(ni:ni+nd-1) else singNam='' 
    if nn gt 0 then normNam=names(ni+nd:ni+nd+nn-1) else normNam='' 
    if debug then print,'++ SingleNames', singnam 
;    if ncols(names) ne nc then print,'Warning: # names not = expected #cols' 
    if (size(names))(1) ne nc then print,'Warning: # names not = expected #cols' 
    readf,unit,arr 
    if ni gt 0 then indv=arr(0:ni-1,*) else indv=0. 
    if nd gt 0 then singDat=arr(ni:ni+nd-1,*) else singdat=0. 
    if nn gt 0 then norm1D=arr(ni+nd:ni+nd+nn-1,*) else norm1D=0. 
endif else begin   ; NO single shot columns present 
    indnam='' 
    indv=0. 
    singnam='' 
    singDat=0. 
    normNam='' 
    norm1D=0. 
    if debug then print, 'No singleshot columns' 
endelse 
  ;print,singnam 
  ;print,indv 
  ;print,singDat 
  ;print,norm1D 
 
;SPECTRA 
  nr=summ(6) ; number of regions 
  n16=summ(7) ; number of 16-channel-snapshot-regions 
  nsp=summ(8) ; number of spectral regions 
 
  i=0 
  s='' 
 
  ;LOAD REGIONS 
  rgnInfo=fltarr(1) 
  xdata=fltarr(1) 
  ydata=fltarr(1) 
  yndata=fltarr(1) 
  if nr gt 0 then begin 
    rgnInfo=fltarr(nr, 5) 
    maxnumpnts=0 
    help,i 
    while s ne 'EOF!' do begin 
      s=read_until_nochar(unit, ';') 
      ;print,strmid(s,0,50) 
      if debug then print,i,'-',s 
      if s ne 'EOF!' then begin 
        ;READ RGNINFO 
        if strmid(s,0,7) ne 'RgnInfo' then print, 'Warning: rgninfo #',i, ' not found.' 
        f=fltarr(1) 
        readf,unit,f 
        if f(0) eq 16 then nnn=3 else nnn=4  ;singleshot has smaller rgninfo then spectrum 
        gg=fltarr(nnn) 
        readf,unit,gg 
        f=[f,gg] 
        rgnInfo(i,0:nnn)=f 
        numpnts=rgninfo(i,0) 
        ; 
        ;READ X-DATA 
        s='' 
        readf,unit,s 
        if debug then print,' -',s 
        if strmid(s,0,1) ne 'x' then print, 'Warning: x #',i, ' not found.' 
        fx=fltarr(numpnts) 
        readf,unit,fx 
        ; 
        ;READ Y-DATA 
        readf,unit,s 
        if debug then print,' -',s 
        if strmid(s,1,1) ne 'y' then print, 'Warning: y #', i, ' not found.' 
	   fy=fltarr(ncy, numpnts) 
        ;if ncy le 2300 then begin 
	   ;  readf,unit,fy 
        ;endif else begin 
          ;print,'Large file--using slower method for loading' 
          ;print,numpnts 
          for j1=0,numpnts-1 do begin 
            ;readf,unit,fy(j1,i1) 
            ba=readstringbig(unit,/byte) 
            fy(*,j1)=parsebytes(ba,ncy) 
          endfor 
        ;endelse 
        fy=rotate(fy,4) 
        ; 
        ; 
        ;READ VF DATA (yn) (optional) 
        hasvf=(phidesc(5) eq 2) and (i) ge n16 
        if hasvf then begin 
          readf,unit,s 
          if debug then print,' -',s 
          if strmid(s,1,2) ne 'yn' then print, 'Warning: yn #', i, ' not found.' 
          fyn=fltarr(ncy, numpnts) 
          readf,unit,fyn 
          fyn=rotate(fyn,4) 
        endif 
        ; 
        ;create or expand existing data arrays 
        if i eq 0 then begin 
          xdata=reform(fx, 1, numpnts) 
          ydata=reform(fy, 1, numpnts, ncy) 
          if hasvf then yndata=reform(fyn, 1, numpnts, ncy) 
          maxnumpnts=numpnts 
        endif else begin 
          if numpnts gt maxnumpnts then begin 
            ;X 
  ;help, xdata, numpnts, maxnumpnts 
            temp=fltarr(i+1, numpnts) 
  ;help, temp 
            temp(0:i-1,0:maxnumpnts-1)=xdata 
            temp(i,*)=fx 
            xdata=temp 
            ;Y 
            temp=fltarr(i+1, numpnts,ncy) 
            temp(0:i-1, 0:maxnumpnts-1, *)=ydata 
            temp(i,*,*)=fy 
            ydata=temp 
            ;YN 
            if hasvf then begin 
              temp=fltarr(i+1, numpnts, ncy) 
              temp(0:i-1, 0:maxnumpnts-1, *)=yndata 
              temp(i,*,*)=fyn 
              yndata=temp 
            endif 
          endif else begin 
            ;add new data, padded w/zeroes, to old data 
            ;X 
            temp=fltarr(i+1, maxnumpnts) 
            temp(0:i-1,*)=xdata 
            temp(i,0:numpnts-1)=fx 
            xdata=temp 
            ;Y 
            temp=fltarr(i+1, maxnumpnts, ncy) 
            temp(0:i-1,*,*)=ydata 
            temp(i,0:numpnts-1, *)=fy 
            ydata=temp 
            ;yn 
            if hasvf then begin 
              temp=fltarr(i+1, maxnumpnts, ncy) 
              temp(0:i-1,*,*)=yndata 
              temp(i,0:numpnts-1,*)=fyn 
              yndata=temp 
            endif 
          endelse 
          maxnumpnts=max([maxnumpnts,numpnts]) 
        endelse 
      endif ; s ne 'EOF!' 
      i=i+1 
    endwhile 
  endif ;read regions 
  close,unit 
  free_lun,unit 
 
  if not keyword_set(noref) then $ 
   answer={fname:fname, summary:summ, phiDescr:phiDesc, $ 
     IndNames:indnam, IndVars:indv, $ 
     SingleNames:singnam, singleData:singDat, $ 
     NormNames:normnam, norm1Dim:norm1D,  RgnInfo:reform(rgninfo), $ 
     x:-1.*reform(xData), y:reform(yData), yn:reform(ynData)} $ 
  else $ 
   answer={fname:fname, summary:summ, phiDescr:phiDesc, $ 
     IndNames:indnam, IndVars:indv, $ 
     SingleNames:singnam, singleData:singDat, $ 
     NormNames:normnam, norm1Dim:norm1D,  RgnInfo:rgninfo, $ 
     x:-1.*xData, y:yData, yn:ynData} 
 
  if not keyword_set(qu) then info, answer 
 
  if keyword_set(plot) then plot_gen,answer 
  return, answer 
end 
