; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_XY_CORRECT
;
;LAST CHANGED: ----------------------------------- 16-Feb-10 (aph)
;
;PURPOSE:
;	This function replaces (x,y) values of an image with
;  x,y values measured interferometrically.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	Result = AX_XY_CORRECT(FILE=FILE)
;
;CALLED FROM AXIS:
;	->Images->XY-CORRECT

;INPUTS: none
;
;KEYWORDS:
;	FILE - if supplied, name of sdf format image file (must have Image, and Xpos, Ypos channels)
;	SILENT - do not display tracking messages
;
;OUTPUTS:
;	corrected image is displayed
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (01-Feb-09 aph) first version
; (10-feb-10 aph) "-" not allowed in function names (changed;IDL 7.x error)
;-
FUNCTION ax_XY_CORRECT, file=file, silent=silent

@axis_com
on_error,2

IF NOT keyword_set(file) then begin
	fltr='*.hdr'
	if keyword_set(nof) then fltr='*'
	file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath)
ENDIF
s = ''
if file EQ '' THEN RETURN, s  ; bail-out if no filename
check = findfile(file)		 ; bail-out if non-existent file
if strlen(check(0)) EQ 0 then begin
	axis_log, 'Cannot find ' + file
	return, s
endif

; ------- read in header file to provide required info

;  THIS IS REPRODUCING read_sdf, which is complex !!

; -------- convert to name of ascii image file (____a.xim)
;t=ax_name(file)
;img_file = t(0)+t(1)+'_a.xim'
;
;; ------- read in uncorrected image
;d = text_read1(img_file)
;;	------ pack into AXIS 2d structure -----------------
;x = read_sdf_ax(ScanDef, region)
;y = read_sdf_ax(ScanDef, region, /y_axis)
;
;; ----- read in x and y-values
;x_file = t(0)+t(1)+'_b.xim'

; assume each of the images have been read into axis - identify by buffers
; task is to re-mesh data to correspond to actual (x,y) positions
; want to interpolate back to original regular array



end
