; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_SPEC_DELETE 
; 
;LAST CHANGED: ----------------------------------- 19-jun-00 
; 
;PURPOSE: 
;	This procedure deletes all data points in a spectrum between user selected 
; x-axis limits. 
; 
;CATEGORY: 
;	AXIS: spectra analysis 
; 
;CALLING SEQUENCE: 
; for procedures: 
;	AX_SPEC_DELETE 
; 
;CALLED FROM AXIS: 
;	->Spectra->Delete 
 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	Spectrum with deleted data is placed in Buffer 0. 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
;	Cursors used to define two limits. All data points 
; betwen limits are deleted. Spectrum is replotted without changing 
; scales in case user has a zoomed scale for more precise deletion. 
; 
;MODIFICATION HISTORY: 
; (31-dec-99 aph) isolated from AXIS_C; AXIS standard documentation 
;- 
 
PRO AX_SPEC_DELETE 
@axis_com
on_error,2 
HANDLE_VALUE, Data(CurBuf), tmp 
IF n_tags(tmp) EQ 0 THEN RETURN 
If tmp.t EQ '1d' then begin 
	SetGraf, 'MainImg' 
	WIDGET_CONTROL, Uprompt, BAD_ID=BadID, SET_VALUE='Select point 1' 
	CURSOR, x1, y1, /UP, /DATA         ;Get two cursor points from the user 
	WIDGET_CONTROL, Uprompt, BAD_ID=BadID, SET_VALUE='Select point 2' 
	CURSOR, x2, y2, /UP, /DATA 
	xlo = x1(0)           ; order x1 (low), x2 (hi) 
	xhi = x2(0) 
	xt = xlo 
	if xhi LT xlo THEN BEGIN 
		xlo = xhi 
		xhi = xt 
	endif 
	xord = sort(tmp.x)            ; sort on x-values to ensure truncate works 
	tmp.x = tmp.x(xord) 
	tmp.d = tmp.d(xord) 
	if xlo LT min(tmp.x) THEN xlo = min(tmp.x)    ; limit region to within data set 
	if xhi GT max(tmp.x) THEN xhi = max(tmp.x) 
	text = 'Delete from' + strcompress(string(xlo)) + ' to' + strcompress(string(xhi)) 
	WIDGET_CONTROL, Uprompt, SET_VALUE = text 
	x = tmp.x & y = tmp.d                           ; default to original data 
	ntl=where(tmp.x LT xlo, nl)                     ; find indices of tmp.x outside 
	nth=where(tmp.x GT xhi, nh)                     ; deleted region 
	n = where(tmp.x,nt) 
	if nl NE 0 AND nh NE 0 then BEGIN               ; delete in middle 
		xl = tmp.x(ntl) & yl = tmp.d(ntl) 
		xh = tmp.x(nth) & yh = tmp.d(nth) 
		x=[xl,xh] 
		y=[yl,yh] 
	endif 
	if nh NE 0 AND nl EQ 0 then BEGIN 
		x = tmp.x(nth) & y = tmp.d(nth)  ; keep end of data 
   	endif 
    if nl NE 0 AND nh EQ 0 then BEGIN 
    	x = tmp.x(ntl) & y = tmp.d(ntl)  ; keep start of data 
    endif 
	tmp.dl = 'DL ' + tmp.dl 
	s={t:'1d', D:y, X:x, XL: tmp.xl, DN: tmp.dn,  DL: tmp.dl} 
	HANDLE_VALUE, Data(0), s, /SET 
	CurBuf = 0                     ; replot without resetting axes 
	pNum = 1 & pBufs(0) = 0 
  	PlotBuf,CurBuf, /same_scale 
ENDIF else  WIDGET_CONTROL, Uprompt, BAD_ID=BadID, SET_VALUE='Delete: not for Images' 
END 
